#include <string>
#include <vector>
#include <fstream>
using namespace std;

#include <qtabdialog.h>
#include <qlineedit.h>
#include <qmainwindow.h>
#include <qpushbutton.h>
#include <qfont.h>
#include <qcheckbox.h>
#include <qtoolbutton.h>

class network;
class appearance;
class fontscolors;
class advanced;

class Preferences : public QTabDialog {
    Q_OBJECT

public:
    Preferences();

    void load();
    
    string startAddress();
    string cacheServer();
    string emailAddress();
    string smtpServer();
    string ircServer();
    string ircNickname( int );
    void toolbarIcons( vector< string > & );
    string iconDir();

    QColor extensionColor();
    QColor visitedColor();
    QColor titleForeground();
    QColor titleBackground();
    QColor highlightForeground();
    QColor highlightBackground();
    QColor backgroundColor();

    vector<int> &keyBindingv();

    QFont sourceFont();
    QFont browserFont();
    QFont ircFont();
    QFont emailFont();

    vector<string> bookmarkv, localv;

    string sourceViewer();
    int upperToolbar();
    int statusBar();
    int editingOptions();

    string webBrowser();
    void setWebBrowser( string );
    string emailClient();
    string ircClient();
    string newsClient();

    int timeoutValue();

    QMainWindow::ToolBarDock dock;

    QRect *maincoords;

public slots:
    void save();

private:
    void loadColor( ifstream &, QColor & );
    void loadLineEdit( string, QLineEdit * );
    void loadCheck( string, QCheckBox * );
    void loadCoords( ifstream &, QRect *& );
    void saveCheck( ofstream &, string, QCheckBox * );
    void saveColor( ofstream &, QColor &, string ); 
    void loadButton( string );
    void saveButton( ofstream &, QToolButton *, string );
    void saveLineEdit( ofstream &, QLineEdit *, string );
    void saveCoords( ofstream &, QWidget * );

    void checkConfig();
    void loadLocals();

    network *netw;
    appearance *appe;
    fontscolors *fcol;
    advanced *adva;
};
