/***************************************************************************
*   Copyright (C) 2004-2006 by Thomas Fischer                             *
*   fischer@unix-ag.uni-kl.de                                             *
*                                                                         *
*   This program is free software; you can redistribute it and/or modify  *
*   it under the terms of the GNU General Public License as published by  *
*   the Free Software Foundation; either version 2 of the License, or     *
*   (at your option) any later version.                                   *
*                                                                         *
*   This program is distributed in the hope that it will be useful,       *
*   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
*   GNU General Public License for more details.                          *
*                                                                         *
*   You should have received a copy of the GNU General Public License     *
*   along with this program; if not, write to the                         *
*   Free Software Foundation, Inc.,                                       *
*   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
***************************************************************************/
#ifndef KBIBTEXWEBQUERY_H
#define KBIBTEXWEBQUERY_H

#include <qobject.h>
#include <qstring.h>

#include <kdialogbase.h>
#include <klistview.h>
#include <klineedit.h>
#include <kio/jobclasses.h>
#include <kprogress.h>

#include "entry.h"

class QWidget;
class QFrame;
class QCheckBox;
class QSpinBox;
class KComboBox;
class KListView;
class KPushButton;

namespace KBibTeX
{
    /**
     @author Thomas Fischer <fischer@unix-ag.uni-kl.de>
    */
    class WebQueryWidget : public QWidget
    {
        Q_OBJECT
    public:
        WebQueryWidget( QWidget *parent, const char *name = 0 );
        virtual bool searchPossible();

        KLineEdit *lineEditQuery;
        QSpinBox *spinBoxMaxHits;

    protected:
        virtual void init();

    signals:
        void enableSearch( bool );
        void startSearch();

    protected slots:
        void slotTextChanged( const QString& );
        void slotTextChanged( const QString&, bool delayed );

    private slots:
        void slotEnableSearchTrue();
    };

    /**
     @author Thomas Fischer <fischer@unix-ag.uni-kl.de>
    */
    class WebQuery : public QObject
    {
        Q_OBJECT
    public:
        enum Status { statusSuccess, statusError, statusAborted, statusInvalidQuery, statusInsufficientPermissions };

        WebQuery( QWidget *parent );
        virtual ~WebQuery();

        virtual void query();

        virtual QString title() { return "no_title"; };
        virtual QString disclaimer() = 0;
        virtual QString disclaimerURL() = 0;

        virtual WebQueryWidget *widget() = 0;

    signals:
        void foundEntry( BibTeX::Entry*, bool );
        void endSearch( WebQuery::Status );

    protected:
        bool m_aborted;
        QWidget *m_parent;
        KProgressDialog *m_progressDialog;

        virtual void cancelQuery();

        void setEndSearch( WebQuery::Status );
        void setNumStages( int numStages );
        void enterNextStage();
        QString download( const KURL& url );
        QString downloadHTML( const KURL& url );
        BibTeX::File *downloadBibTeXFile( const KURL& url, QTextStream::Encoding = QTextStream::UnicodeUTF8 );

    private:
        int m_currentStage;
        int m_numStages;
        KIO::TransferJob *m_currentJob;
        int m_currentJobTotalSize;
        QString m_incomingData;

    private slots:
        void slotCancelQuery();
        void slotSetJobTotalSize( KIO::Job *job, KIO::filesize_t size );
        void slotSetJobProcessedSize( KIO::Job *job, KIO::filesize_t size );
        void slotJobData( KIO::Job *job, const QByteArray &data );
        void slotJobFinished( KIO::Job *job );
    };

    class WebQueryWizard: public QWidget
    {
        Q_OBJECT
    public:
        ~WebQueryWizard();

        static int execute( QWidget *parent, QValueList<BibTeX::Entry*> &results );

    signals:
        void changeButtonOK( bool state );

    protected:
        KListView *m_listViewResults;
        KComboBox *m_comboBoxEngines;
        QWidgetStack *m_widgetStackQueries;
        KURLLabel *m_disclaimerLabel;
        QCheckBox *m_checkBoxImportAll;
        QValueList<WebQuery*> m_webQueries;
        KDialogBase *m_dlg;

        WebQueryWizard( KDialogBase *dlg, const char* name = 0 );
        void showEvent( QShowEvent * );

    private slots:
        void previewEntry( QListViewItem *item );
        void importEnableChanging( );
        void otherEngineSelected( int index );
        void startSearch();
        void endSearch( WebQuery::Status );
        void addHit( BibTeX::Entry*, bool keepId = false );
        void enableSearch( bool );
        void openURL( const QString& );

    private:
        KPushButton *m_pushButtonSearch;

        void setupGUI( );
        void setupQueries();
        void restoreWindowSize( KConfig *config );
        void saveWindowSize( KConfig *config ) const;
    };

    class ResultsListViewItem: public QListViewItem
    {
    public:
        ResultsListViewItem( QListView * parent, BibTeX::Entry *entry );
        ~ResultsListViewItem();

        BibTeX::Entry* entry();
    private:
        BibTeX::Entry *m_entry;
    };
}

#endif
