/***************************************************************************
                                 dock.cpp
                             -------------------
    begin                : Thu Aug 5 1999
    copyright            : (C) 1999 by Markus Gustavsson
    email                : mighty@fragzone.se
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/


#include "dock.h"

Dock::Dock(QWidget *mainwin, QWidget *parent, const char *name) : QWidget(parent,name)
{
	KWin::setSystemTrayWindowFor(winId(), mainwin->winId());
	setBackgroundColor(QColor(0, 0, 0));
	resize(24, 24);
	show();

	buf = (int *) calloc(24, sizeof(int));
	buf2 = (int *) calloc(24, sizeof(int));

	c2.setRgb(255, 255, 255);

	pos = 0;
	old = 0;
	old2 = 0;
}

Dock::~Dock()
{
	free(buf);
	free(buf2);
}

void Dock::setGrid(bool set)
{
	grid = set;
	repaint();
}

void Dock::setFill(int set)
{
	fill = set;
	repaint();
}

void Dock::setCol(int set)
{
	col = set;
	repaint();
}

void Dock::setCPU(int set)
{
	cpu = set;
	repaint();
}

void Dock::setText(bool set)
{
	text = set;
	repaint();
}

void Dock::setSoft(bool set)
{
	soft = set;
	repaint();
}

void Dock::setSplit(bool set)
{
	split = set;
	repaint();
}

void Dock::setOn(bool set)
{
	on = set;
	repaint();
}

void Dock::setClr(void)
{
	for(i = 0; i < 24; i++) *(buf + i) = 0;
	repaint();
}

void Dock::mousePressEvent(QMouseEvent *Event)
{
	emit mouseClick(Event);
}

void Dock::paintEvent(QPaintEvent *Event)
{
	Event = (QPaintEvent *) 0;
	QPainter p(this);

	if(grid) {
		p.setPen((on) ? QColor(120, 120, 120) : QColor(60, 60, 60));
		p.drawLine(0, 4, 23, 4);
		p.drawLine(0, 9, 23, 9);
		p.drawLine(0, 14, 23, 14);
		p.drawLine(0, 19, 23, 19);
	}

	if(fill == 2) {

		for(i = 0; i < 24; i++) {

			tmp = (pos + i + 1 < 24) ? *(buf + pos + i + 1) : *(buf + pos + i - 23);
			if(split) tmp4 = (pos + i + 1 < 24) ? *(buf2 + pos + i + 1) : *(buf2 + pos + i - 23);

			for(i2 = 0; i2 <= tmp; i2++) {
				tmp2 = (tmp) ? (255 / tmp) * i2 : 0;
				tmp3 = (tmp) ? ((255 / tmp) * i2) / 2 : 0;

				if(col == 0) p.setPen((on) ? QColor(0, 0, tmp2) : QColor(0, 0, tmp3));
				else if(col == 1) p.setPen((on) ? QColor(0, tmp2, 0) : QColor(0, tmp3, 0));
				else if(col == 2) p.setPen((on) ? QColor(tmp2, tmp2 / 2, 0) : QColor(tmp3, tmp3 / 2, 0));
				else if(col == 3) p.setPen((on) ? QColor(tmp2, 0, tmp2) : QColor(tmp3, 0, tmp3));
				else if(col == 4) p.setPen((on) ? QColor(tmp2, 0, 0) : QColor(tmp3, 0, 0));
				else if(col == 5) p.setPen((on) ? QColor(0, tmp2, tmp2) : QColor(0, tmp3, tmp3));
				else p.setPen((on) ? QColor(tmp2, tmp2, 0) : QColor(tmp3, tmp3, 0));

				if(split) p.drawPoint(i, 23 - i2 - tmp4);
				else p.drawPoint(i, 23 - i2);
			}

			if(split) {
				for(i2 = 0; i2 <= tmp4; i2++) {
					tmp2 = (tmp4) ? (255 / tmp4) * i2 : 0;
					tmp3 = (tmp4) ? ((255 / tmp4) * i2) / 2 : 0;
					p.setPen((on) ? QColor(tmp2, tmp2, tmp2) : QColor(tmp3, tmp3, tmp3));
					p.drawPoint(i, 23 - i2);
				}
			}

		}

	} else {

		if(col == 0) (on) ? c1.setRgb(0, 0, 255) : c1.setRgb(0, 0, 128);
		else if(col == 1) (on) ? c1.setRgb(0, 255, 0) : c1.setRgb(0, 128, 0);
		else if(col == 2) (on) ? c1.setRgb(255, 128, 0) : c1.setRgb(128, 64, 0);
		else if(col == 3) (on) ? c1.setRgb(255, 0, 255) : c1.setRgb(128, 0, 128);
		else if(col == 4) (on) ? c1.setRgb(255, 0, 0) : c1.setRgb(128, 0, 0);
		else if(col == 5) (on) ? c1.setRgb(0, 255, 255) : c1.setRgb(0, 128, 128);
		else (on) ? c1.setRgb(255, 255, 0) : c1.setRgb(128, 128, 0);

		if(fill == 1) {
			if(split) {
				for(i = 0; i < 24; i++) {
					tmp = (pos + i + 1 < 24) ? *(buf + pos + i + 1) : *(buf + pos + i - 23);
					tmp2 = (pos + i + 1 < 24) ? *(buf2 + pos + i + 1) : *(buf2 + pos + i - 23);

					p.setPen(c1);
					p.drawLine(i, 23 - tmp - tmp2, i, 23 - tmp2);
					p.setPen(c2);
					p.drawLine(i, 23 - tmp2, i, 23);
				}
			} else {
				p.setPen(c1);
				for(i = 0; i < 24; i++) p.drawLine(i, 23 - ((pos + i + 1 < 24) ? *(buf + pos + i + 1) : *(buf + pos + i - 23)), i, 23);
			}
		} else {
			if(split) {
				for(i = 0; i < 24; i++) {
					tmp = (pos + i + 1 < 24) ? *(buf + pos + i + 1) : *(buf + pos + i - 23);
					tmp2 = (pos + i + 1 < 24) ? *(buf2 + pos + i + 1) : *(buf2 + pos + i - 23);

					p.setPen(c1);
					p.drawPoint(i, 23 - tmp - tmp2);
					p.setPen(c2);
					p.drawPoint(i, 23 - tmp2);
				}
			} else {
				p.setPen(c1);
				for(i = 0; i < 24; i++) p.drawPoint(i, 23 - ((pos + i + 1 < 24) ? *(buf + pos + i + 1) : *(buf + pos + i - 23)));
			}
		}
	}

	if(text) {
		p.setFont(QFont("Helvetica", 8));
		p.setPen((on) ? QColor(255, 255, 255) : QColor(125, 125, 125));
		switch(cpu) {
			case 0: p.drawText(rect(), AlignLeft | AlignTop, "C");
			break;
			case 1: p.drawText(rect(), AlignLeft | AlignTop, "C 0");
			break;
			case 2: p.drawText(rect(), AlignLeft | AlignTop, "C 1");
			break;
		}
	}
}

void Dock::step(int val, int val2)
{
	if(++pos > 23) pos = 0;

	tmp = (int) ((float) val / (float) 4.347);
	if(soft) {
		if(tmp == (old + 1)) old += 1;
		if(tmp == (old + 2)) old += 2;
		if(tmp >= (old + 3)) old += 3;
		if(tmp == (old - 1)) old -= 1;
		if(tmp == (old - 2)) old -= 2;
		if(tmp <= (old - 3)) old -= 3;
		*(buf + pos) = old;
	} else *(buf + pos) = tmp;

	if(split) {
		tmp = (int) ((float) val2 / (float) 4.347);
		if(soft) {
			if(tmp == (old2 + 1)) old2 += 1;
			if(tmp == (old2 + 2)) old2 += 2;
			if(tmp >= (old2 + 3)) old2 += 3;
			if(tmp == (old2 - 1)) old2 -= 1;
			if(tmp == (old2 - 2)) old2 -= 2;
			if(tmp <= (old2 - 3)) old2 -= 3;
			*(buf2 + pos) = old2;
		} else *(buf2 + pos) = tmp;
	}

	repaint();
}







