/*
 * This file is part of the DOM implementation for KDE.
 *
 * Copyright 2003 Lars Knoll (knoll@kde.org)
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this library; see the file COPYING.LIB.  If not, write to
 * the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
 */

/* This file is mostly data generated by flex. Unfortunately flex
   can't handle 16bit strings directly, so we just copy the part of
   the code we need and modify it to our needs.

   Most of the defines below are to make sure we can easily use the
   flex generated code, using as little editing as possible.

   The flex syntax to generate the lexer are more or less directly
   copied from the CSS2.1 specs, with some fixes for comments and
   the important symbol.

   To regenerate, run flex on tokenizer.flex. After this, copy the
   data tables and the YY_DECL method over to this file. Remove the
   init code from YY_DECL and change the YY_END_OF_BUFFER to only call
   yyterminate().

*/

// --------- begin generated code -------------------


#include "parser.h"

#define INITIAL 0
#define mediaquery 1

/* C99 systems have <inttypes.h>. Non-C99 systems may or may not. */

#if defined __STDC_VERSION__ && __STDC_VERSION__ >= 199901L
#include <inttypes.h>
typedef int8_t flex_int8_t;
typedef uint8_t flex_uint8_t;
typedef int16_t flex_int16_t;
typedef uint16_t flex_uint16_t;
typedef int32_t flex_int32_t;
typedef uint32_t flex_uint32_t;
#else
typedef signed char flex_int8_t;
typedef short int flex_int16_t;
typedef int flex_int32_t;
typedef unsigned char flex_uint8_t;
typedef unsigned short int flex_uint16_t;
typedef unsigned int flex_uint32_t;
#endif /* ! C99 */
#define YY_NUM_RULES 59
#define YY_END_OF_BUFFER 60
/* This struct is not used in this scanner,
   but its presence is necessary. */
struct yy_trans_info
	{
	flex_int32_t yy_verify;
	flex_int32_t yy_nxt;
	};
static yyconst flex_int16_t yy_accept[365] =
    {   0,
        0,    0,    0,    0,   60,   58,    2,    2,   58,   58,
       58,   58,   58,   58,   58,   58,   58,   48,   58,   58,
       58,   58,   14,   14,   14,   58,   58,   58,   48,   57,
       14,   14,   14,   56,    2,    0,    0,    0,   13,    0,
       16,    0,    8,    0,    0,    9,    0,    0,    0,   14,
       14,   49,    0,   47,    0,    0,   48,    0,   46,   46,
       46,   46,   46,   46,   46,   46,   46,   46,   15,   46,
       46,   41,    0,    0,    0,    0,    0,    0,    0,    0,
       14,   14,    7,   53,   14,    0,    0,   14,   14,    0,
       14,    6,    5,   49,    0,   48,   46,   14,   14,   14,

        0,    0,    0,   13,    0,    0,   16,   16,    0,    0,
       13,    0,    0,    4,   15,    0,    0,   46,   46,   46,
        0,   46,   32,   46,   28,   30,   46,   42,   34,   46,
       33,   40,   46,   36,   35,   31,   46,    0,    0,    0,
        0,    0,    0,    0,    0,   14,   14,   14,   15,   14,
       14,   54,   54,   14,   46,   12,   10,   14,    0,    0,
        0,   16,    0,    0,    0,    1,   46,   46,   46,   46,
       37,   46,   45,   15,   38,    3,    0,    0,    0,    0,
        0,    0,    0,   14,   14,   50,    0,   54,   54,   54,
       53,   46,   43,   11,    0,    0,   16,    0,    0,    0,

       46,   46,   46,   39,    0,    0,    0,    0,    0,    0,
       18,   14,   14,   55,   54,   54,   54,   54,    0,    0,
        0,    0,   52,    0,   44,    0,    0,   16,    0,   46,
       46,   29,    0,    0,    0,    0,   19,    0,   14,   14,
       55,   54,   54,   54,   54,   54,    0,    0,    0,    0,
        0,    0,    0,    0,    0,   52,    0,    0,    0,    0,
       16,    0,   46,   46,    0,    0,    0,   17,    0,   14,
       14,   55,   54,   54,   54,   54,   54,   54,    0,   51,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,   16,    0,   46,   46,    0,   21,    0,

        0,   14,   55,   54,   54,   54,   54,   54,   54,   54,
        0,   51,    0,    0,    0,   51,    0,    0,    0,    0,
       46,    0,    0,    0,    0,    0,    0,   55,    0,    0,
        0,   27,    0,    0,    0,    0,   20,   22,   55,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,   23,    0,    0,    0,   24,    0,   25,    0,    0,
        0,    0,   26,    0
    } ;

static yyconst flex_int32_t yy_ec[256] =
    {   0,
        1,    1,    1,    1,    1,    1,    1,    1,    2,    3,
        1,    4,    5,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    6,    7,    8,    9,   10,   11,   12,   13,   14,
       15,   16,   17,   12,   18,   19,   20,   21,   21,   21,
       21,   21,   21,   21,   21,   21,   21,   12,   22,   23,
       24,   25,   26,   27,   31,   32,   33,   34,   35,   36,
       37,   38,   39,   40,   41,   42,   43,   44,   45,   46,
       47,   48,   49,   50,   51,   52,   40,   53,   54,   55,
       12,   28,   12,   29,   30,   12,   31,   32,   33,   34,

       35,   36,   37,   38,   39,   40,   41,   42,   43,   44,
       45,   46,   47,   48,   49,   50,   51,   52,   40,   53,
       54,   55,   56,   57,   12,   58,    1,   59,   59,   59,
       59,   59,   59,   59,   59,   59,   59,   59,   59,   59,
       59,   59,   59,   59,   59,   59,   59,   59,   59,   59,
       59,   59,   59,   59,   59,   59,   59,   59,   59,   59,
       59,   59,   59,   59,   59,   59,   59,   59,   59,   59,
       59,   59,   59,   59,   59,   59,   59,   59,   59,   59,
       59,   59,   59,   59,   59,   59,   59,   59,   59,   59,
       59,   59,   59,   59,   59,   59,   59,   59,   59,   59,

       59,   59,   59,   59,   59,   59,   59,   59,   59,   59,
       59,   59,   59,   59,   59,   59,   59,   59,   59,   59,
       59,   59,   59,   59,   59,   59,   59,   59,   59,   59,
       59,   59,   59,   59,   59,   59,   59,   59,   59,   59,
       59,   59,   59,   59,   59,   59,   59,   59,   59,   59,
       59,   59,   59,   59,   59
    } ;

static yyconst flex_int32_t yy_meta[60] =
    {   0,
        1,    2,    3,    3,    3,    4,    4,    4,    4,    4,
        4,    4,    4,    5,    4,    4,    4,    6,    4,    4,
        6,    4,    4,    4,    4,    7,    4,    8,    4,    8,
        9,    9,    9,    9,    9,    9,    8,    8,    8,    8,
        8,    8,    8,    8,    8,    8,    8,    8,    8,    8,
        8,    8,    8,    8,    8,    4,    4,    4,    8
    } ;

static yyconst flex_int16_t yy_base[393] =
    {   0,
        0,    0,   41,   45,  923, 1708,   75,   89,  100,   60,
      893,  896,   56,  885,   89,  887,  885,  129,  886,   80,
      110,  861,   47,  104,  172,  853,  845,  838,   93, 1708,
      171,  173,  178, 1708,  132,  191,  815,   92, 1708,  229,
      829,  177, 1708,   83,  264, 1708,  831,  107,  193,   59,
      221,  198,  839, 1708,  822,  828,    0,  220,  124,  820,
       87,  188,  193,   81,  215,   55,  220,  231,  254,  251,
       43,  818,  821,  797,  799,  791,  792,  793,  795,  793,
      259,  303, 1708, 1708,  261,  294,  802,  262,  304,  324,
      274, 1708, 1708,  327,  801,  328,  275,  338,  337,  339,

      775,  283,  285,  286,  386,  421,  784,  456,  365,  351,
      356,  491,  526, 1708,  138,  795,  187,  782,  561,  781,
      364,  294,  780,  305,  773,  771,  174,  769,  768,  315,
      767,  766,  219,  752,  751,  750,  346,  759,  737,  743,
      729,  726,  724,  714,  719,  412,  349,  596,  715,  387,
      388,  294,  709,  399,  402,  422,  423,  451,  689,  375,
      482,  517,  450,  552,  715, 1708,  587,  702,  631,  347,
      701,  376,  700,  384,  686, 1708,  663,  661,  658,  661,
      659,  661,  659,  622,  638, 1708,  647,  413,  667,  666,
      682,  438,  663,  454,  629,  668,  684,  690,  660,  303,

      706,  712,  442,  647,  618,  611,  633,  602,  618,  599,
     1708,  728,  734,  750,  414,  621,  620,  619,  785,  812,
      378,  458, 1708,  839,  616,  592,  771,  798,  830,  847,
      855,  612,  597,  574,  571,  556, 1708,  557,  863,  871,
      879,  446,  553,  552,  551,  550,  496,  512,  530,  914,
      493,  949,  984, 1011, 1038, 1065, 1092, 1127,  543,  905,
      940,  970,  997, 1024,  528,  494,  512, 1708,  511, 1051,
     1083, 1118,  449,  511,  484,  483,  482,  481,  566, 1708,
      704,  547, 1162, 1189, 1224,  577,  528, 1170, 1259, 1294,
     1168,  439, 1215, 1250, 1285,  610, 1302, 1058, 1708,  447,

      443, 1310, 1318,  456, 1708, 1708, 1708, 1708, 1708, 1708,
     1203,  583,  596, 1326, 1361,  597,  613, 1347, 1363,  423,
      748,  434,  403,  383,  397,  376,  374, 1369, 1385, 1391,
     1407, 1708,  343,  339,  302,  298, 1708, 1708, 1708, 1413,
     1429, 1435,  239,  239,  210,  193, 1451, 1457, 1473,  155,
      127, 1708,  118, 1479, 1495, 1708,   78, 1708,   57,   47,
       22,   11, 1708, 1708, 1530, 1534, 1542, 1546, 1552, 1557,
     1565, 1571, 1579, 1588, 1590, 1596, 1600, 1606, 1615, 1621,
     1625, 1634, 1638, 1646, 1650, 1658, 1666, 1674, 1678, 1686,
     1694, 1698

    } ;

static yyconst flex_int16_t yy_def[393] =
    {   0,
      364,    1,    1,    1,  364,  364,  364,  364,  364,  365,
      366,  364,  367,  364,  368,  364,  364,  364,  364,  364,
      369,  364,  370,  370,  370,  364,  364,  364,   18,  364,
      370,  370,  370,  364,  364,  364,  364,  365,  364,  371,
      366,  372,  364,  367,  373,  364,  364,  364,  369,  370,
      370,   18,  374,  364,  375,  364,   18,  376,  377,  377,
      377,  377,  377,  377,  377,  377,  377,  377,  377,  377,
      377,  377,  364,  364,  364,  364,  364,  364,  364,  364,
      370,  370,  364,  364,  370,  378,  364,  370,  370,  364,
      370,  364,  364,   18,  364,   18,  377,  370,  370,  370,

      364,  365,  365,  365,  365,  371,  366,  366,  367,  367,
      367,  367,  373,  364,  364,  374,  379,  377,  377,  377,
      380,  377,  377,  377,  377,  377,  377,  377,  377,  377,
      377,  377,  377,  377,  377,  377,  377,  364,  364,  364,
      364,  364,  364,  364,  364,   82,  370,   82,  364,  370,
      370,  381,  364,  370,  377,  370,  370,  370,  364,  365,
      105,  108,  367,  112,  382,  364,  119,  377,  119,  377,
      377,  377,  377,  377,  377,  364,  364,  364,  364,  364,
      364,  364,  364,   82,  148,  364,  364,  383,  364,  364,
      384,  377,  377,  370,  364,  105,  108,  112,  382,  379,

      119,  169,  377,  377,  364,  364,  364,  364,  364,  364,
      364,   82,  148,  364,  385,  364,  364,  364,  384,  384,
      386,  387,  364,  388,  377,  364,  105,  108,  112,  119,
      169,  377,  364,  364,  364,  364,  364,  364,   82,  148,
      364,  389,  364,  364,  364,  364,  364,  386,  364,  390,
      387,  391,  384,  384,  384,  384,  384,  388,  364,  105,
      108,  112,  119,  169,  364,  364,  364,  364,  364,   82,
      148,  364,  392,  364,  364,  364,  364,  364,  364,  364,
      386,  386,  386,  386,  390,  387,  387,  387,  387,  391,
      257,  364,  105,  108,  112,  377,  169,  364,  364,  364,

      364,  148,  364,  364,  364,  364,  364,  364,  364,  364,
      386,  386,  386,  284,  387,  387,  387,  289,  257,  364,
      377,  364,  364,  364,  364,  364,  364,  364,  284,  289,
      257,  364,  364,  364,  364,  364,  364,  364,  364,  284,
      289,  257,  364,  364,  364,  364,  284,  289,  257,  364,
      364,  364,  364,  284,  289,  364,  364,  364,  364,  364,
      364,  364,  364,    0,  364,  364,  364,  364,  364,  364,
      364,  364,  364,  364,  364,  364,  364,  364,  364,  364,
      364,  364,  364,  364,  364,  364,  364,  364,  364,  364,
      364,  364

    } ;

static yyconst flex_int16_t yy_nxt[1768] =
    {   0,
        6,    7,    8,    7,    7,    7,    9,   10,   11,   12,
        6,    6,   13,    6,    6,   14,    6,   15,   16,   17,
       18,    6,   19,    6,    6,    6,   20,   21,   22,   23,
       23,   23,   23,   23,   23,   23,   23,   23,   23,   23,
       23,   23,   23,   24,   23,   23,   23,   23,   23,   23,
       25,   23,   23,   23,   23,    6,   26,   27,   23,   28,
       84,   29,   30,   28,  363,   29,   30,   39,   39,  362,
      121,   31,   84,  137,   86,   31,   35,   35,   35,   35,
       35,  361,  121,   45,   32,   33,   86,   40,   32,   33,
       35,   35,   35,   35,   35,   39,   34,   74,  129,   39,

       34,   36,   36,   36,   36,   36,   47,  360,  121,   48,
       45,   95,   75,   96,  121,   76,   49,   84,   77,   40,
       87,   88,   78,   79,  359,   80,   97,   48,  127,  123,
       82,   86,   51,   35,   35,   35,   35,   35,   37,   54,
       82,   82,   82,   82,   82,   82,   55,   56,   89,   57,
      115,  121,  358,  122,   87,   87,   58,  357,   59,   60,
       60,   61,   62,   63,   60,   64,   65,   66,   60,   67,
       60,   68,   69,   60,   70,   60,   71,   72,   60,   60,
       60,   60,   60,   60,   84,   84,   84,   60,   90,   87,
       88,   84,   36,   36,   36,   36,   36,  108,   86,   86,

       86,  121,  117,  356,  172,   86,  166,  108,  108,  108,
      108,  108,  108,   82,   98,  121,  364,   99,   52,   91,
      121,  100,  124,   82,   82,   82,   82,   82,   82,   37,
       38,   38,   38,  102,   84,  125,  104,   87,   88,  174,
      119,   60,  121,  353,  352,  126,  121,  121,   86,  105,
      119,  119,  119,  119,  119,  119,  106,  130,  121,  105,
      105,  105,  105,  105,  105,   44,   44,   44,  109,  128,
       87,  133,   84,  131,   84,   84,  111,  351,  121,  132,
      350,  121,  150,  134,  112,   38,   86,   84,   86,   86,
       39,  113,   39,   39,  112,  112,  112,  112,  112,  112,

      135,   86,  121,  136,   81,   81,   81,   81,   81,  124,
       40,  187,   40,   40,  148,  154,   84,   84,  200,  189,
      155,  121,  166,  146,  148,  148,  148,  148,  148,  148,
       86,   86,  121,  146,  146,  146,  146,  146,  146,  346,
      170,  171,  121,  345,  152,  364,   95,   94,   96,  153,
       84,   84,   84,  151,  152,  152,  152,  152,  152,  152,
       97,   97,   84,   39,   86,   86,   86,   44,   39,  173,
       60,  156,  344,  121,  121,  343,   86,   39,   45,  175,
      158,  203,   39,   45,  169,  249,  157,  103,  160,  160,
      160,  103,   45,   39,  169,  169,  169,  169,  169,  169,

       84,  186,   40,  121,  174,  250,  161,  150,  338,  204,
      337,  121,  191,   40,   86,   86,  161,  161,  161,  161,
      161,  161,   38,   38,   38,  102,   86,  336,  104,  121,
      187,  187,  184,  335,  192,   84,  186,  334,  216,  243,
      193,  105,  184,  184,  184,  184,  184,  184,  106,   86,
       86,  105,  105,  105,  105,  105,  105,  107,  107,  107,
      107,  107,   39,  187,   84,  121,  187,   84,  333,  121,
      249,  274,  332,  187,  305,  327,  162,   45,   86,  326,
      225,   86,  320,   42,  232,  252,  162,  162,  162,  162,
      162,  162,  110,  163,  163,  163,  110,  247,  247,  247,

      247,  247,  196,   39,  194,  249,  310,  309,  308,  307,
      223,  164,  196,  196,  196,  196,  196,  196,   45,  249,
      252,  164,  164,  164,  164,  164,  164,   44,   44,   44,
      109,  279,  279,  279,  279,  279,  306,  197,  111,  250,
      249,  301,  300,  299,  280,  298,  112,  197,  197,  197,
      197,  197,  197,  113,  249,  252,  112,  112,  112,  112,
      112,  112,  118,  118,  118,  118,  118,  279,  279,  279,
      279,  279,  198,  292,  250,  278,  277,  276,  275,  251,
      280,  167,  198,  198,  198,  198,  198,  198,  121,  249,
      249,  167,  167,  167,  167,  167,  167,  147,  147,  147,

      147,  147,  269,  249,  252,  268,  267,  201,  266,  249,
      250,  118,  118,  118,  118,  118,  185,  201,  201,  201,
      201,  201,  201,  250,  252,  249,  185,  185,  185,  185,
      185,  185,  168,  168,  168,  168,  168,  121,  265,  121,
      252,  259,  212,  121,  246,  245,  244,  238,  237,  236,
      235,  202,  212,  212,  212,  212,  212,  212,  213,  234,
      233,  202,  202,  202,  202,  202,  202,  214,  213,  213,
      213,  213,  213,  213,  121,  200,  226,  214,  214,  214,
      214,  214,  214,  219,  219,  219,  219,  219,  227,  221,
      121,  218,  217,  211,  222,  210,  223,  209,  227,  227,

      227,  227,  227,  227,  228,  208,  248,  207,  206,  224,
      229,  249,  205,  121,  228,  228,  228,  228,  228,  228,
      229,  229,  229,  229,  229,  229,  230,  121,  121,  121,
      200,  250,  231,  195,  190,  149,  230,  230,  230,  230,
      230,  230,  231,  231,  231,  231,  231,  231,  239,  168,
      168,  168,  168,  168,  240,  183,  182,  181,  239,  239,
      239,  239,  239,  239,  240,  240,  240,  240,  240,  240,
      241,  180,  179,  178,  177,  121,  176,  121,  121,  121,
      241,  241,  241,  241,  241,  241,  219,  219,  219,  219,
      219,  260,  221,  121,  121,  121,  121,  222,  121,  223,

      121,  260,  260,  260,  260,  260,  260,  121,  121,  121,
      117,   42,  224,  247,  247,  247,  247,  247,  261,  364,
      159,   94,  149,  145,  364,  144,  223,  143,  261,  261,
      261,  261,  261,  261,  142,  141,  140,  139,  138,  224,
      247,  247,  247,  247,  253,  121,  255,  121,   52,   58,
      262,  255,  255,  256,  117,  114,   42,  101,   94,  257,
      262,  262,  262,  262,  262,  262,  258,  263,   93,  257,
      257,  257,  257,  257,  257,  264,   92,  263,  263,  263,
      263,  263,  263,  270,   83,  264,  264,  264,  264,  264,
      264,  271,   73,  270,  270,  270,  270,  270,  270,  272,

       53,  271,  271,  271,  271,  271,  271,   52,   46,  272,
      272,  272,  272,  272,  272,  248,  248,  248,  281,   43,
       42,  283,  364,  364,  364,  293,  364,  364,  364,  364,
      364,  364,  364,  364,  284,  293,  293,  293,  293,  293,
      293,  285,  364,  364,  284,  284,  284,  284,  284,  284,
      251,  251,  251,  286,  364,  364,  364,  364,  364,  364,
      294,  288,  364,  364,  364,  364,  364,  364,  364,  289,
      294,  294,  294,  294,  294,  294,  290,  364,  364,  289,
      289,  289,  289,  289,  289,  247,  247,  247,  247,  247,
      295,  364,  364,  364,  364,  364,  364,  364,  223,  364,

      295,  295,  295,  295,  295,  295,  364,  364,  364,  364,
      364,  224,  247,  247,  247,  247,  247,  296,  364,  364,
      364,  364,  364,  364,  364,  223,  364,  296,  296,  296,
      296,  296,  296,  364,  364,  364,  364,  364,  224,  247,
      247,  247,  247,  247,  297,  364,  364,  364,  364,  364,
      364,  364,  223,  364,  297,  297,  297,  297,  297,  297,
      364,  364,  364,  364,  364,  224,  247,  247,  247,  247,
      247,   85,  364,  364,  364,  364,  364,  364,  364,  223,
      364,   85,   85,   85,   85,   85,   85,  364,  364,  364,
      364,  322,  224,  253,  253,  253,  253,  253,  364,  364,

      323,  364,  364,  302,  364,  324,  223,  364,  364,  325,
      364,  364,  291,  302,  302,  302,  302,  302,  302,  224,
      364,  364,  291,  291,  291,  291,  291,  291,  247,  247,
      247,  247,  253,  364,  255,  364,  364,  364,  303,  255,
      255,  256,  364,  364,  364,  364,  364,  257,  303,  303,
      303,  303,  303,  303,  258,  364,  364,  257,  257,  257,
      257,  257,  257,  311,  279,  279,  279,  311,  364,  249,
      364,  315,  279,  279,  279,  315,  312,  364,  364,  364,
      364,  364,  249,  364,  316,  364,  364,  364,  319,  250,
      282,  313,  313,  313,  282,  364,  249,  252,  319,  319,

      319,  319,  319,  319,  311,  279,  279,  279,  311,  314,
      249,  364,  364,  364,  364,  364,  250,  312,  364,  314,
      314,  314,  314,  314,  314,  248,  248,  248,  281,  364,
      250,  283,  364,  364,  364,   38,  364,  364,  364,  364,
      364,  364,  364,  364,  284,   38,   38,   38,   38,   38,
       38,  285,  364,  364,  284,  284,  284,  284,  284,  284,
      287,  317,  317,  317,  287,  364,  364,  364,  364,  364,
       41,  249,  364,  364,  364,  364,  364,  364,  364,  318,
       41,   41,   41,   41,   41,   41,  252,  364,  364,  318,
      318,  318,  318,  318,  318,  251,  251,  251,  286,  364,

      364,  364,  364,  364,  364,   44,  288,  364,  364,  364,
      364,  364,  364,  364,  289,   44,   44,   44,   44,   44,
       44,  290,  321,  364,  289,  289,  289,  289,  289,  289,
       85,  364,  321,  321,  321,  321,  321,  321,  328,  364,
       85,   85,   85,   85,   85,   85,  329,  364,  328,  328,
      328,  328,  328,  328,  364,  364,  329,  329,  329,  329,
      329,  329,  315,  279,  279,  279,  315,  330,  364,  364,
      364,  364,  364,  249,  364,  316,  364,  330,  330,  330,
      330,  330,  330,  331,  364,  364,  364,  364,  252,  339,
      364,  364,  364,  331,  331,  331,  331,  331,  331,  339,

      339,  339,  339,  339,  339,  340,  364,  364,  364,  364,
      364,  341,  364,  364,  364,  340,  340,  340,  340,  340,
      340,  341,  341,  341,  341,  341,  341,  342,  364,  364,
      364,  364,  364,  347,  364,  364,  364,  342,  342,  342,
      342,  342,  342,  347,  347,  347,  347,  347,  347,  348,
      364,  364,  364,  364,  364,  349,  364,  364,  364,  348,
      348,  348,  348,  348,  348,  349,  349,  349,  349,  349,
      349,  354,  364,  364,  364,  364,  364,  355,  364,  364,
      364,  354,  354,  354,  354,  354,  354,  355,  355,  355,
      355,  355,  355,  220,  364,  364,  364,  364,  364,  248,

      364,  364,  364,  220,  220,  220,  220,  220,  220,  248,
      248,  248,  248,  248,  248,  251,  364,  364,  364,  364,
      364,  364,  364,  364,  364,  251,  251,  251,  251,  251,
      251,   38,  364,   38,   38,   38,   38,   38,   38,   41,
      364,   41,   41,   44,  364,   44,   44,   44,   44,   44,
       44,   50,  364,   50,   50,   81,   81,   81,   81,   81,
       81,   85,   85,  364,   85,   85,  103,  103,  103,  103,
      103,  103,  103,  103,  107,  107,  107,  107,  107,  107,
      110,  110,  110,  110,  110,  110,  110,  110,  116,  116,
      116,  116,  116,  116,  116,  116,  116,   60,   60,  118,

      118,  118,  118,  118,  118,  120,  364,  120,  120,  147,
      147,  147,  147,  147,  147,  165,  165,  165,  165,  165,
      165,  165,  165,  165,  168,  168,  168,  168,  168,  168,
      188,  188,  364,  188,  199,  199,  199,  199,  199,  199,
      199,  199,  199,  215,  215,  364,  215,  220,  220,  220,
      364,  220,  220,  220,  220,  242,  242,  364,  242,  248,
      364,  248,  248,  248,  248,  248,  248,  251,  364,  251,
      251,  251,  251,  251,  251,  254,  254,  254,  254,  254,
      254,  254,  254,  273,  273,  364,  273,  282,  282,  282,
      282,  282,  282,  282,  282,  287,  287,  287,  287,  287,

      287,  287,  287,  304,  304,  364,  304,    5,  364,  364,
      364,  364,  364,  364,  364,  364,  364,  364,  364,  364,
      364,  364,  364,  364,  364,  364,  364,  364,  364,  364,
      364,  364,  364,  364,  364,  364,  364,  364,  364,  364,
      364,  364,  364,  364,  364,  364,  364,  364,  364,  364,
      364,  364,  364,  364,  364,  364,  364,  364,  364,  364,
      364,  364,  364,  364,  364,  364,  364
    } ;

static yyconst flex_int16_t yy_chk[1768] =
    {   0,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    3,
       23,    3,    3,    4,  362,    4,    4,   10,   13,  361,
       71,    3,   50,   71,   23,    4,    7,    7,    7,    7,
        7,  360,   66,   13,    3,    3,   50,   10,    4,    4,
        8,    8,    8,    8,    8,   44,    3,   20,   66,   38,

        4,    9,    9,    9,    9,    9,   15,  359,   64,   15,
       44,   29,   20,   29,   61,   20,   15,   24,   20,   38,
       24,   24,   20,   20,  357,   20,   29,   48,   64,   61,
       21,   24,   15,   35,   35,   35,   35,   35,    9,   18,
       21,   21,   21,   21,   21,   21,   18,   18,   24,   18,
       48,   59,  353,   59,  115,  115,   18,  351,   18,   18,
       18,   18,   18,   18,   18,   18,   18,   18,   18,   18,
       18,   18,   18,   18,   18,   18,   18,   18,   18,   18,
       18,   18,   18,   18,   31,   25,   32,   18,   25,   32,
       32,   33,   36,   36,   36,   36,   36,   42,   31,   25,

       32,  127,  117,  350,  127,   33,  117,   42,   42,   42,
       42,   42,   42,   49,   31,   62,   52,   32,   52,   25,
       63,   33,   62,   49,   49,   49,   49,   49,   49,   36,
       40,   40,   40,   40,   51,   63,   40,   51,   51,  133,
       58,   52,   65,  346,  345,   63,  133,   67,   51,   40,
       58,   58,   58,   58,   58,   58,   40,   67,   68,   40,
       40,   40,   40,   40,   40,   45,   45,   45,   45,   65,
       69,   69,   81,   68,   85,   88,   45,  344,   70,   68,
      343,   69,   88,   70,   45,  102,   81,   91,   85,   88,
      102,   45,  103,  104,   45,   45,   45,   45,   45,   45,

       70,   91,   97,   70,   82,   82,   82,   82,   82,   97,
      102,  152,  103,  104,   86,   91,   82,   89,  200,  152,
       97,  122,  200,   82,   86,   86,   86,   86,   86,   86,
       82,   89,  124,   82,   82,   82,   82,   82,   82,  336,
      122,  124,  130,  335,   90,   94,   96,   94,   96,   90,
       99,   98,  100,   89,   90,   90,   90,   90,   90,   90,
       94,   96,  147,  110,   99,   98,  100,  109,  111,  130,
       94,   98,  334,  137,  170,  333,  147,  109,  110,  137,
      100,  170,  160,  111,  121,  221,   99,  105,  105,  105,
      105,  105,  109,  105,  121,  121,  121,  121,  121,  121,

      150,  151,  160,  172,  174,  221,  105,  150,  327,  172,
      326,  174,  154,  105,  150,  151,  105,  105,  105,  105,
      105,  105,  106,  106,  106,  106,  154,  325,  106,  155,
      188,  215,  146,  324,  155,  156,  157,  323,  188,  215,
      155,  106,  146,  146,  146,  146,  146,  146,  106,  156,
      157,  106,  106,  106,  106,  106,  106,  108,  108,  108,
      108,  108,  163,  242,  158,  192,  273,  194,  322,  203,
      222,  242,  320,  304,  273,  301,  108,  163,  158,  300,
      192,  194,  292,  108,  203,  222,  108,  108,  108,  108,
      108,  108,  112,  112,  112,  112,  112,  247,  247,  247,

      247,  247,  161,  112,  158,  251,  278,  277,  276,  275,
      247,  112,  161,  161,  161,  161,  161,  161,  112,  248,
      251,  112,  112,  112,  112,  112,  112,  113,  113,  113,
      113,  249,  249,  249,  249,  249,  274,  162,  113,  248,
      287,  269,  267,  266,  249,  265,  113,  162,  162,  162,
      162,  162,  162,  113,  282,  287,  113,  113,  113,  113,
      113,  113,  119,  119,  119,  119,  119,  279,  279,  279,
      279,  279,  164,  259,  282,  246,  245,  244,  243,  286,
      279,  119,  164,  164,  164,  164,  164,  164,  119,  286,
      312,  119,  119,  119,  119,  119,  119,  148,  148,  148,

      148,  148,  238,  313,  286,  236,  235,  167,  234,  316,
      312,  296,  296,  296,  296,  296,  148,  167,  167,  167,
      167,  167,  167,  313,  316,  317,  148,  148,  148,  148,
      148,  148,  169,  169,  169,  169,  169,  296,  233,  232,
      317,  226,  184,  225,  218,  217,  216,  210,  209,  208,
      207,  169,  184,  184,  184,  184,  184,  184,  185,  206,
      205,  169,  169,  169,  169,  169,  169,  187,  185,  185,
      185,  185,  185,  185,  204,  199,  195,  187,  187,  187,
      187,  187,  187,  191,  191,  191,  191,  191,  196,  191,
      193,  190,  189,  183,  191,  182,  191,  181,  196,  196,

      196,  196,  196,  196,  197,  180,  281,  179,  178,  191,
      198,  281,  177,  175,  197,  197,  197,  197,  197,  197,
      198,  198,  198,  198,  198,  198,  201,  173,  171,  168,
      165,  281,  202,  159,  153,  149,  201,  201,  201,  201,
      201,  201,  202,  202,  202,  202,  202,  202,  212,  321,
      321,  321,  321,  321,  213,  145,  144,  143,  212,  212,
      212,  212,  212,  212,  213,  213,  213,  213,  213,  213,
      214,  142,  141,  140,  139,  321,  138,  136,  135,  134,
      214,  214,  214,  214,  214,  214,  219,  219,  219,  219,
      219,  227,  219,  132,  131,  129,  128,  219,  126,  219,

      125,  227,  227,  227,  227,  227,  227,  123,  120,  118,
      116,  107,  219,  220,  220,  220,  220,  220,  228,  220,
      101,   95,   87,   80,  220,   79,  220,   78,  228,  228,
      228,  228,  228,  228,   77,   76,   75,   74,   73,  220,
      224,  224,  224,  224,  224,   72,  224,   60,   56,   55,
      229,  224,  224,  224,   53,   47,   41,   37,   28,  224,
      229,  229,  229,  229,  229,  229,  224,  230,   27,  224,
      224,  224,  224,  224,  224,  231,   26,  230,  230,  230,
      230,  230,  230,  239,   22,  231,  231,  231,  231,  231,
      231,  240,   19,  239,  239,  239,  239,  239,  239,  241,

       17,  240,  240,  240,  240,  240,  240,   16,   14,  241,
      241,  241,  241,  241,  241,  250,  250,  250,  250,   12,
       11,  250,    5,    0,    0,  260,    0,    0,    0,    0,
        0,    0,    0,    0,  250,  260,  260,  260,  260,  260,
      260,  250,    0,    0,  250,  250,  250,  250,  250,  250,
      252,  252,  252,  252,    0,    0,    0,    0,    0,    0,
      261,  252,    0,    0,    0,    0,    0,    0,    0,  252,
      261,  261,  261,  261,  261,  261,  252,    0,    0,  252,
      252,  252,  252,  252,  252,  253,  253,  253,  253,  253,
      262,  253,    0,    0,    0,    0,  253,    0,  253,    0,

      262,  262,  262,  262,  262,  262,    0,    0,    0,    0,
        0,  253,  254,  254,  254,  254,  254,  263,  254,    0,
        0,    0,    0,  254,    0,  254,    0,  263,  263,  263,
      263,  263,  263,    0,    0,    0,    0,    0,  254,  255,
      255,  255,  255,  255,  264,  255,    0,    0,    0,    0,
      255,    0,  255,    0,  264,  264,  264,  264,  264,  264,
        0,    0,    0,    0,    0,  255,  256,  256,  256,  256,
      256,  270,  256,    0,    0,    0,    0,  256,    0,  256,
        0,  270,  270,  270,  270,  270,  270,    0,    0,    0,
        0,  298,  256,  257,  257,  257,  257,  257,    0,  257,

      298,    0,    0,  271,  257,  298,  257,    0,    0,  298,
        0,    0,  257,  271,  271,  271,  271,  271,  271,  257,
        0,    0,  257,  257,  257,  257,  257,  257,  258,  258,
      258,  258,  258,    0,  258,    0,    0,    0,  272,  258,
      258,  258,    0,    0,    0,    0,    0,  258,  272,  272,
      272,  272,  272,  272,  258,    0,    0,  258,  258,  258,
      258,  258,  258,  283,  283,  283,  283,  283,    0,  283,
        0,  288,  288,  288,  288,  288,  283,    0,    0,    0,
        0,    0,  288,    0,  288,    0,    0,    0,  291,  283,
      284,  284,  284,  284,  284,    0,  284,  288,  291,  291,

      291,  291,  291,  291,  311,  311,  311,  311,  311,  284,
      311,    0,    0,    0,    0,    0,  284,  311,    0,  284,
      284,  284,  284,  284,  284,  285,  285,  285,  285,    0,
      311,  285,    0,    0,    0,  293,    0,    0,    0,    0,
        0,    0,    0,    0,  285,  293,  293,  293,  293,  293,
      293,  285,    0,    0,  285,  285,  285,  285,  285,  285,
      289,  289,  289,  289,  289,    0,    0,    0,    0,    0,
      294,  289,    0,    0,    0,    0,    0,    0,    0,  289,
      294,  294,  294,  294,  294,  294,  289,    0,    0,  289,
      289,  289,  289,  289,  289,  290,  290,  290,  290,    0,

        0,    0,    0,    0,    0,  295,  290,    0,    0,    0,
        0,    0,    0,    0,  290,  295,  295,  295,  295,  295,
      295,  290,  297,    0,  290,  290,  290,  290,  290,  290,
      302,    0,  297,  297,  297,  297,  297,  297,  303,    0,
      302,  302,  302,  302,  302,  302,  314,    0,  303,  303,
      303,  303,  303,  303,    0,    0,  314,  314,  314,  314,
      314,  314,  315,  315,  315,  315,  315,  318,    0,    0,
        0,    0,    0,  315,    0,  315,    0,  318,  318,  318,
      318,  318,  318,  319,    0,    0,    0,    0,  315,  328,
        0,    0,    0,  319,  319,  319,  319,  319,  319,  328,

      328,  328,  328,  328,  328,  329,    0,    0,    0,    0,
        0,  330,    0,    0,    0,  329,  329,  329,  329,  329,
      329,  330,  330,  330,  330,  330,  330,  331,    0,    0,
        0,    0,    0,  340,    0,    0,    0,  331,  331,  331,
      331,  331,  331,  340,  340,  340,  340,  340,  340,  341,
        0,    0,    0,    0,    0,  342,    0,    0,    0,  341,
      341,  341,  341,  341,  341,  342,  342,  342,  342,  342,
      342,  347,    0,    0,    0,    0,    0,  348,    0,    0,
        0,  347,  347,  347,  347,  347,  347,  348,  348,  348,
      348,  348,  348,  349,    0,    0,    0,    0,    0,  354,

        0,    0,    0,  349,  349,  349,  349,  349,  349,  354,
      354,  354,  354,  354,  354,  355,    0,    0,    0,    0,
        0,    0,    0,    0,    0,  355,  355,  355,  355,  355,
      355,  365,    0,  365,  365,  365,  365,  365,  365,  366,
        0,  366,  366,  367,    0,  367,  367,  367,  367,  367,
      367,  368,    0,  368,  368,  369,  369,  369,  369,  369,
      369,  370,  370,    0,  370,  370,  371,  371,  371,  371,
      371,  371,  371,  371,  372,  372,  372,  372,  372,  372,
      373,  373,  373,  373,  373,  373,  373,  373,  374,  374,
      374,  374,  374,  374,  374,  374,  374,  375,  375,  376,

      376,  376,  376,  376,  376,  377,    0,  377,  377,  378,
      378,  378,  378,  378,  378,  379,  379,  379,  379,  379,
      379,  379,  379,  379,  380,  380,  380,  380,  380,  380,
      381,  381,    0,  381,  382,  382,  382,  382,  382,  382,
      382,  382,  382,  383,  383,    0,  383,  384,  384,  384,
        0,  384,  384,  384,  384,  385,  385,    0,  385,  386,
        0,  386,  386,  386,  386,  386,  386,  387,    0,  387,
      387,  387,  387,  387,  387,  388,  388,  388,  388,  388,
      388,  388,  388,  389,  389,    0,  389,  390,  390,  390,
      390,  390,  390,  390,  390,  391,  391,  391,  391,  391,

      391,  391,  391,  392,  392,    0,  392,  364,  364,  364,
      364,  364,  364,  364,  364,  364,  364,  364,  364,  364,
      364,  364,  364,  364,  364,  364,  364,  364,  364,  364,
      364,  364,  364,  364,  364,  364,  364,  364,  364,  364,
      364,  364,  364,  364,  364,  364,  364,  364,  364,  364,
      364,  364,  364,  364,  364,  364,  364,  364,  364,  364,
      364,  364,  364,  364,  364,  364,  364
    } ;

YY_DECL
{
	register yy_state_type yy_current_state;
	register unsigned short *yy_cp, *yy_bp;
	register int yy_act;
	while ( 1 )		/* loops until end-of-file is reached */
		{
		yy_cp = (yy_c_buf_p);

		/* Support of yytext. */
		*yy_cp = (yy_hold_char);

		/* yy_bp points to the position in yy_ch_buf of the start of
		 * the current run.
		 */
		yy_bp = yy_cp;

		yy_current_state = (yy_start);
		do
			{
			register YY_CHAR yy_c = yy_ec[YY_SC_TO_UI(*yy_cp)];
			if ( yy_accept[yy_current_state] )
				{
				(yy_last_accepting_state) = yy_current_state;
				(yy_last_accepting_cpos) = yy_cp;
				}
			while ( yy_chk[yy_base[yy_current_state] + yy_c] != yy_current_state )
				{
				yy_current_state = (int) yy_def[yy_current_state];
				if ( yy_current_state >= 365 )
					yy_c = yy_meta[(unsigned int) yy_c];
				}
			yy_current_state = yy_nxt[yy_base[yy_current_state] + (unsigned int) yy_c];
			++yy_cp;
			}
		while ( yy_base[yy_current_state] != 1708 );

yy_find_action:
		yy_act = yy_accept[yy_current_state];
		if ( yy_act == 0 )
			{ /* have to back up */
			yy_cp = (yy_last_accepting_cpos);
			yy_current_state = (yy_last_accepting_state);
			yy_act = yy_accept[yy_current_state];
			}

		YY_DO_BEFORE_ACTION;


		switch ( yy_act )
	{ /* beginning of action switch */
			case 0: /* must back up */
			/* undo the effects of YY_DO_BEFORE_ACTION */
			*yy_cp = (yy_hold_char);
			yy_cp = (yy_last_accepting_cpos);
			yy_current_state = (yy_last_accepting_state);
			goto yy_find_action;

case 1:
/* rule 1 can match eol */
YY_RULE_SETUP
#line 29 "tokenizer.flex"
/* ignore comments */
	YY_BREAK
case 2:
/* rule 2 can match eol */
YY_RULE_SETUP
#line 31 "tokenizer.flex"
{yyTok = S; return yyTok;}
	YY_BREAK
case 3:
YY_RULE_SETUP
#line 33 "tokenizer.flex"
{yyTok = SGML_CD; return yyTok;}
	YY_BREAK
case 4:
YY_RULE_SETUP
#line 34 "tokenizer.flex"
{yyTok = SGML_CD; return yyTok;}
	YY_BREAK
case 5:
YY_RULE_SETUP
#line 35 "tokenizer.flex"
{yyTok = INCLUDES; return yyTok;}
	YY_BREAK
case 6:
YY_RULE_SETUP
#line 36 "tokenizer.flex"
{yyTok = DASHMATCH; return yyTok;}
	YY_BREAK
case 7:
YY_RULE_SETUP
#line 37 "tokenizer.flex"
{yyTok = BEGINSWITH; return yyTok;}
	YY_BREAK
case 8:
YY_RULE_SETUP
#line 38 "tokenizer.flex"
{yyTok = ENDSWITH; return yyTok;}
	YY_BREAK
case 9:
YY_RULE_SETUP
#line 39 "tokenizer.flex"
{yyTok = CONTAINS; return yyTok;}
	YY_BREAK
case 10:
YY_RULE_SETUP
#line 40 "tokenizer.flex"
{yyTok = MEDIA_NOT; return yyTok;}
	YY_BREAK
case 11:
YY_RULE_SETUP
#line 41 "tokenizer.flex"
{yyTok = MEDIA_ONLY; return yyTok;}
	YY_BREAK
case 12:
YY_RULE_SETUP
#line 42 "tokenizer.flex"
{yyTok = MEDIA_AND; return yyTok;}
	YY_BREAK
case 13:
/* rule 13 can match eol */
YY_RULE_SETUP
#line 44 "tokenizer.flex"
{yyTok = STRING; return yyTok;}
	YY_BREAK
case 14:
/* rule 14 can match eol */
YY_RULE_SETUP
#line 46 "tokenizer.flex"
{yyTok = IDENT; return yyTok;}
	YY_BREAK
case 15:
YY_RULE_SETUP
#line 48 "tokenizer.flex"
{yyTok = NTH; return yyTok;}
	YY_BREAK
case 16:
/* rule 16 can match eol */
YY_RULE_SETUP
#line 50 "tokenizer.flex"
{yyTok = HASH; return yyTok;}
	YY_BREAK
case 17:
YY_RULE_SETUP
#line 52 "tokenizer.flex"
{BEGIN(mediaquery); yyTok = IMPORT_SYM; return yyTok;}
	YY_BREAK
case 18:
YY_RULE_SETUP
#line 53 "tokenizer.flex"
{yyTok = PAGE_SYM; return yyTok;}
	YY_BREAK
case 19:
YY_RULE_SETUP
#line 54 "tokenizer.flex"
{BEGIN(mediaquery); yyTok = MEDIA_SYM; return yyTok;}
	YY_BREAK
case 20:
YY_RULE_SETUP
#line 55 "tokenizer.flex"
{yyTok = FONT_FACE_SYM; return yyTok;}
	YY_BREAK
case 21:
YY_RULE_SETUP
#line 56 "tokenizer.flex"
{yyTok = CHARSET_SYM; return yyTok;}
	YY_BREAK
case 22:
YY_RULE_SETUP
#line 57 "tokenizer.flex"
{yyTok = NAMESPACE_SYM; return yyTok; }
	YY_BREAK
case 23:
YY_RULE_SETUP
#line 58 "tokenizer.flex"
{yyTok = KHTML_RULE_SYM; return yyTok; }
	YY_BREAK
case 24:
YY_RULE_SETUP
#line 59 "tokenizer.flex"
{yyTok = KHTML_DECLS_SYM; return yyTok; }
	YY_BREAK
case 25:
YY_RULE_SETUP
#line 60 "tokenizer.flex"
{yyTok = KHTML_VALUE_SYM; return yyTok; }
	YY_BREAK
case 26:
YY_RULE_SETUP
#line 61 "tokenizer.flex"
{BEGIN(mediaquery); yyTok = KHTML_MEDIAQUERY_SYM; return yyTok; }
	YY_BREAK
case 27:
/* rule 27 can match eol */
YY_RULE_SETUP
#line 63 "tokenizer.flex"
{yyTok = IMPORTANT_SYM; return yyTok;}
	YY_BREAK
case 28:
YY_RULE_SETUP
#line 65 "tokenizer.flex"
{yyTok = EMS; return yyTok;}
	YY_BREAK
case 29:
YY_RULE_SETUP
#line 66 "tokenizer.flex"
{yyTok = QEMS; return yyTok;} /* quirky ems */
	YY_BREAK
case 30:
YY_RULE_SETUP
#line 67 "tokenizer.flex"
{yyTok = EXS; return yyTok;}
	YY_BREAK
case 31:
YY_RULE_SETUP
#line 68 "tokenizer.flex"
{yyTok = PXS; return yyTok;}
	YY_BREAK
case 32:
YY_RULE_SETUP
#line 69 "tokenizer.flex"
{yyTok = CMS; return yyTok;}
	YY_BREAK
case 33:
YY_RULE_SETUP
#line 70 "tokenizer.flex"
{yyTok = MMS; return yyTok;}
	YY_BREAK
case 34:
YY_RULE_SETUP
#line 71 "tokenizer.flex"
{yyTok = INS; return yyTok;}
	YY_BREAK
case 35:
YY_RULE_SETUP
#line 72 "tokenizer.flex"
{yyTok = PTS; return yyTok;}
	YY_BREAK
case 36:
YY_RULE_SETUP
#line 73 "tokenizer.flex"
{yyTok = PCS; return yyTok;}
	YY_BREAK
case 37:
YY_RULE_SETUP
#line 74 "tokenizer.flex"
{yyTok = DEGS; return yyTok;}
	YY_BREAK
case 38:
YY_RULE_SETUP
#line 75 "tokenizer.flex"
{yyTok = RADS; return yyTok;}
	YY_BREAK
case 39:
YY_RULE_SETUP
#line 76 "tokenizer.flex"
{yyTok = GRADS; return yyTok;}
	YY_BREAK
case 40:
YY_RULE_SETUP
#line 77 "tokenizer.flex"
{yyTok = MSECS; return yyTok;}
	YY_BREAK
case 41:
YY_RULE_SETUP
#line 78 "tokenizer.flex"
{yyTok = SECS; return yyTok;}
	YY_BREAK
case 42:
YY_RULE_SETUP
#line 79 "tokenizer.flex"
{yyTok = HERZ; return yyTok;}
	YY_BREAK
case 43:
YY_RULE_SETUP
#line 80 "tokenizer.flex"
{yyTok = DPI; return yyTok;}
	YY_BREAK
case 44:
YY_RULE_SETUP
#line 81 "tokenizer.flex"
{yyTok = DPCM; return yyTok;}
	YY_BREAK
case 45:
YY_RULE_SETUP
#line 82 "tokenizer.flex"
{yyTok = KHERZ; return yyTok;}
	YY_BREAK
case 46:
/* rule 46 can match eol */
YY_RULE_SETUP
#line 83 "tokenizer.flex"
{yyTok = DIMEN; return yyTok;}
	YY_BREAK
case 47:
YY_RULE_SETUP
#line 84 "tokenizer.flex"
{yyTok = PERCENTAGE; return yyTok;}
	YY_BREAK
case 48:
YY_RULE_SETUP
#line 85 "tokenizer.flex"
{yyTok = INTEGER; return yyTok;}
	YY_BREAK
case 49:
YY_RULE_SETUP
#line 86 "tokenizer.flex"
{yyTok = FLOAT; return yyTok;}
	YY_BREAK
case 50:
YY_RULE_SETUP
#line 89 "tokenizer.flex"
{yyTok = NOTFUNCTION; return yyTok;}
	YY_BREAK
case 51:
/* rule 51 can match eol */
YY_RULE_SETUP
#line 90 "tokenizer.flex"
{yyTok = URI; return yyTok;}
	YY_BREAK
case 52:
/* rule 52 can match eol */
YY_RULE_SETUP
#line 91 "tokenizer.flex"
{yyTok = URI; return yyTok;}
	YY_BREAK
case 53:
/* rule 53 can match eol */
YY_RULE_SETUP
#line 92 "tokenizer.flex"
{yyTok = FUNCTION; return yyTok;}
	YY_BREAK
case 54:
YY_RULE_SETUP
#line 94 "tokenizer.flex"
{yyTok = UNICODERANGE; return yyTok;}
	YY_BREAK
case 55:
YY_RULE_SETUP
#line 95 "tokenizer.flex"
{yyTok = UNICODERANGE; return yyTok;}
	YY_BREAK
case 56:
#line 98 "tokenizer.flex"
case 57:
YY_RULE_SETUP
#line 98 "tokenizer.flex"
{BEGIN(INITIAL); yyTok = *yytext; return yyTok; }
	YY_BREAK
case 58:
YY_RULE_SETUP
#line 99 "tokenizer.flex"
{yyTok = *yytext; return yyTok;}
	YY_BREAK
case 59:
YY_RULE_SETUP
#line 101 "tokenizer.flex"
ECHO;
	YY_BREAK
#line 1525 "<stdout>"
case YY_STATE_EOF(INITIAL):
case YY_END_OF_BUFFER:
case YY_STATE_EOF(mediaquery):
	yyterminate();

	default:
		YY_FATAL_ERROR(
			"fatal flex scanner internal error--no action found" );
	} /* end of action switch */
		} /* end of scanning one token */
} /* end of yylex */
