/***************************************************************************
                          kdesupport.h  -  description
                             -------------------
    begin                : Mon Feb 5 2001
    copyright            : (C) 2001 by Richard Dale
    email                : Lost_Highway@tipitina.demon.co.uk
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KDESUPPORT_H
#define KDESUPPORT_H

#include <jni.h>

#include <ktrader.h>
#include <kmainwindow.h>
#include <kfile.h>
#include <kfileview.h>
#include <kurl.h>
#include <kcmdlineargs.h>
#include <dom/dom_string.h>
#include <dom/dom_node.h>
#include <dom/css_stylesheet.h>


/** A class with various static utility methods to help run the C++ side
	of the KDE Java library.

	@author Richard Dale */

class KDESupport {
public: 
	KDESupport() {};
	~KDESupport() {};
	
	/** Convert from Java String to DOM::DOMString */
	static DOM::DOMString * toDOMString(JNIEnv * env, jstring str, DOM::DOMString ** domstring);
	static jstring fromDOMString(JNIEnv * env, DOM::DOMString * domstring);
	
	/** Convert from a Java ArrayList to a KURL::List */
	static KURL::List * toKURLList(JNIEnv * env, jobjectArray urlList, KURL::List ** kurlList);
	/** Convert from a Java ArrayList to a KFileItemList */
	static KFileItemList * toKFileItemList(JNIEnv * env, jobjectArray itemList, KFileItemList ** kitemList);
	
	/** Converts java options entries to the C++ KCmdLineOption equivalent */
	static KCmdLineOptions * toKCmdLineOptions(JNIEnv * env, jobjectArray optionsArray);
	
	/** Returns a Java ArrayList for the various types of KDE List */
	static jobject arrayWithQCStringList(JNIEnv * env, QCStringList * qcstringList);
	static jobject arrayWithOfferList(JNIEnv * env, KTrader::OfferList * offerList);
	static jobject arrayWithKMainWindowList(JNIEnv * env, QList<KMainWindow> * memberList);
	static jobject arrayWithKFileItemList(JNIEnv * env, QList<KFileItem> * itemList);
	static jobject arrayWithKFileViewItemList(JNIEnv * env, QList<KFileViewItem> * itemList);
	static jobject arrayWithKURLList(JNIEnv * env, KURL::List * kurlList);
	static jobject arrayWithNodeList(JNIEnv * env, DOM::NodeList * nodeList);
	static jobject arrayWithStyleSheetList(JNIEnv * env, DOM::StyleSheetList * styleSheetList);
	static jobject arrayWithMediaList(JNIEnv * env, DOM::MediaList * mediaList);
};

#endif
