/***************************************************************************
                            AddressBook.java -  description
                             -------------------
    begin                : Sun Aug 26 09:45:02 2001
    copyright            : (C) 2000-2001 Lost Highway Ltd.
    email                : Richard_Dale@tipitina.demon.co.uk
    generated by         : duke@tipitina on Sun Aug 26 09:45:02 2001, using kdoc parser/custom Java conversion backend.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
***************************************************************************/

package org.kde.koala;

import org.kde.qt.*;
import java.util.*;
import java.lang.Error;

/**
 The class AddressBook implements the base class for the KDE addressbook. 
  \par Overview
  It
  is used by the KabAPI to make the interface to kab files available to 
  application programmers. <BR> 
  Unlike in the first kab version, the configuration file and the data file are 
  different objects of QConfigDB.  This way,  the data file is no more limited
  to the one in the users KDE directory, multiple files may be used.  Different
  instances of the program may use different data files.  Read-only addressbook
  files are possible. <BR>
  Only one configuration file per user is used, it is <BR>
  <TT>   ~/.kde/share/apps/kab/kab.config </TT> <BR>
  A standard user file will automatically be created as <BR> 
  <TT>   ~/.kde/share/apps/kab/addressbook.kab </TT> <BR>
  File changes are watched by the program, so every instance will automatically
  update its database on a change of the opened file. 

  \par The KDE addressbook database system
  kab manages entries in address databases based on a key system where the 
  program assigns keys to added entries. These keys are not reused in one file, 
  so API users can rely on a key to be unique and identifying until the entry 
  is deleted by the user (this is a change to kab 1 that reused freed entry 
  keys). Of course, in different files a key might be used twice. <BR>
  The keys are objects of the type KabKey and define the section in the 
  addressbook database where the entry is stored (see QConfigDB
  reference). Keys invalidate on file changes, so keep track of the
  signal .changed. <BR>
  kab watches file changes. If the opened file changes on disk, it is
  automatically reloaded and .changed() is emitted. 

  \par The users standard personal information database
  kab assumes that it is able to read and write the users standard database.
  This way, the kab application itselfes and applications using the KabAPI can
  rely on the possibility to add entries to this database (from a browser, for
  example). Usually, this file is opened automatically by the constructor. 
  If - for what reason ever - the file cannot be either created or read, kab 
  will still start up, but no database operation will work until the user 
  opened a file. In this case, the method .getState will return 
  .PermDenied. In general it is a good idea to check the return value of the
  .getState method before using KabAPI operations.

  \par The mirror map
  The entries are stored in the QConfigDB object .data which represents the
  currently opened file. In every file there is a section with the name 
  <TT> entries </TT> that contains a subsection for every entry. The name of
  the subsection is the key of the entry. <BR>
  When retrieving the sections, they are ordered alphabetically by their keys.
  This is not what users expect, since the keys show the insertion order of 
  the entries, not more and not less. Additionally the displaying order should
  be configurable. <BR>
  That is why kab uses a STL map to map its entry keys to user
  (at least programmer...) defined descriptors. Usually, the descriptors are 
  created as a combination of the entry data, and then displayed in aphabetical 
  order in the selector combobox. This map is called the mirror map throughout 
  the documentation. It is created or updated everytime the database changes.
  Thus the way to find a special entry is: <OL>
  <LI> the user selects an item in the selector combo box, returning its 
       index, </LI>
  <LI> the index is used to find the key of the entry in the mirror map, </LI>
  <LI> and finally the entry is retrieved by its key from the database. </LI>
  </OL>
  To modify the sorting order, the way to create the entry descriptors in the 
  mirror map nedds to be changed. 

  \par The view
  If you display an AddressBook object (that is a derived QFrame), 
  it may show an entry 
  of the database that you might select. The entry you hand over to the method
  .displayEntry does not need to be contained in the currently loaded file.
  This way you may integrate views of 
  the users addressbook database in your own application as a simple widget 
  type. To allow the user to
  navigate through the database, you might want to show kab's own toolbar in 
  your mainwindow (or whereever). (The toolbar is not implemented by now). <BR>
  Some parts of the AddressBook widget are \e interactive, that means they are
  displayed as transparent KURLLabels that react when the user clicks on it.
  These interactive parts have to be enabled by calling #setInteractiveMode. 
 See {@link AddressBookSignals} for signals emitted by AddressBook.

 See {@link AddressBookEventHandling} for event handlers to override in subclasses of AddressBook.

 @short  The class AddressBook implements the base class for the KDE addressbook.
*/
public class AddressBook extends QFrame  {
	protected AddressBook(Class dummy){super((Class) null);}


/**  The constructor. If \e load is true, the user standard file will
  automatically be loaded into the object. 
*/
	private native void newAddressBook( QWidget parent, String name, boolean load);
	public AddressBook( QWidget parent, String name, boolean load) {
		super((Class) null);
		newAddressBook( parent, name, load);
	}
	private native void newAddressBook();
	public AddressBook() {
		super((Class) null);
		newAddressBook();
	}
	protected native void finalize() throws InternalError;

/**  Get the internal state of the object. 
  If no problem occured, it returns .NoError. 
  If the standard or the latest opened file could not be loaded,
  it returns .PermDenied.
*/
	public native int getState();

/**  Load the file with the given path. An empty file name reloads the 
  currently opened file. 
*/
	public native int load( String filename);
	public native int load();

/**  Save the file to the given path and file name.  An empty file name saves 
  to the file where the database has been read from.
  If force is true, the method will switch to r/w mode for saving and
  back. 
*/
	public native int save( String filename, boolean force);
	public native int save();

/**  Close this file. 
  .closeFile assures sure that the .data object is reset no matter of the 
  state of the assigned file. 
  If \a save is true, it will not close the file if it could not be 
  saved. 
*/
	public native int closeFile( boolean saveit);
	public native int closeFile();

/**  Retrieve an entry from the database by its key. 
*/
	public native int getEntry( KabKey key, Entry arg1);

/**  Retrieve the Section of the entry directly, returning a section object. 
*/
	public native int getEntry( KabKey key, Section arg1);

/**  Add an .Entry, \a return the new key for further operations.
  If update is false, the mirror map will not be affected, if it is true,
  the mirror map gets updated, too. 
*/
	public native int add( Entry arg1, KabKey key, boolean update);
	public native int add( Entry arg1, KabKey key);

/**  Set the entry with the given key to the new contents. Be aware of
  #PermDenied for read-only databases or file sharing conflicts. You cannot 
  change entries in a database for which you do not have write access. 
*/
	public native int change( KabKey key, Entry arg1);

/**  Remove the  entry with the given key. Returns #NoSuchEntry if there is no 
  entry with this key, #PermDenied for read only databases. 
*/
	public native int remove( KabKey key);

/**  Returns the number of entries in the loaded database. 
*/
	public native int noOfEntries();

/**  This method returns the literal name for the entry, 
 containing either the formatted name (if given) or a 
 combination of the first, additional and last name. 
 The name is returned in \a text.
 If \a reverse is false, the text looks like
    firstname (add. name) last name,
 if it is true, 
    +    last name, first name (add. name).
 If \a initials is true, the text contains initials only:
    f. a. name [with reverse==false] or
    name, f. a. [with reverse==true].
 If there is no entry with this key, the method returns .NoSuchEntry.
    
*/
	public native int literalName( KabKey key, String text, boolean reverse, boolean initials);
	public native int literalName( KabKey key, String text);

/**  This is an overloaded method that differs only in the arguments it takes.
   
*/
	public native int literalName( Entry entry, String text, boolean reverse, boolean initials);
	public native int literalName( Entry entry, String text);

/**  Get the key of the item in the selector with the given index. 
*/
	public native int getKey( int index, KabKey arg1);

/**  Get the index of this key in the selector. This is the reverse
      functionality to getKey(). 
*/
	public native int getIndex( KabKey arg1, int arg2);

/**  Fill the string list with name lines. If your application shows a combobox 
  containing an overview over the currently loaded KabAPI database, then 
  call this method when receiving the signal .changed and display the list
  in the combo. 
*/
	public native int getListOfNames( String[] arg1, boolean reverse, boolean initials);
	public native int getListOfNames( String[] arg1);

/**  Hand over the configuration database. Careful! 
*/
//	public native QConfigDB getConfig();

/**  This method returns the QConfigDB section where the configuration of the
      currently opened file is stored. It might be used to retrieve or to modify
      these settings. The file-specific settings are saved along with
      the open file.
      Do not confuse the configuration section of the opened file with 
      the configuration of the program. Each file might have its own
      local configuration for some settings where it makes sense. 
      @ return Null if no file has been opened. 
  
*/
	public native Section configurationSection();

/**  Creates a new database with the given file name. If the filename is 
  empty, it creates the users standard data file. The method does not load
  the new database. 
*/
	public native int createNew( String filename);
	public native int createNew();

/**  Creates the local configuration file. The filename is fixed to
  \c kab.config, it will be created in the local kab directory
  (\c $HOME/.kde/share/apps/kab). Adapt the global configuration template
  file (\c $KDEDIR/share/apps/kab/template.config) for unusual site-specific
  settings.
  The method does not load the new config file. 
*/
	public native int createConfigFile();
	public native int loadConfigFile();

/**  This method parses a vCard and creates an Entry object from it. 
*/
	public native int makeEntryFromVCard( String card, Entry arg1);

/**  This method creates a vCard string from an entry. 
*/
	public native int makeVCardFromEntry( Entry entry, String card);

/**  Returns the complete path to the user standard file. An empty path
  indicates an error, but this should not happen. It is NOT ensured
  that the file exists. 
*/
	public native String getStandardFilename();

/**  This slot is called when an external object changed the database through
      the kabapi. 
*/
	public native void externalChange();

/**  Call this to get a telephone type translated to the locale. 
*/
	public static native String phoneType( int arg1);

/**  Get the next available entry key for this file. For internal use only. 
*/
	protected native KabKey nextAvailEntryKey();

/**  Returns true if both pathes point to the same file.
  The method resolves relative file names to find this out. 
*/
	protected native boolean isSameFile( String a, String b);

/**  Parse the section and copy its contents into \a entry.
  The method expects a subsection called \e addresses that contains a
  number of subsections each containing data for one Entry.Address object.
  All other fields are copied directly into the members of \a entry. 
*/
	protected native int makeEntryFromSection( Section arg1, Entry arg2);

/**  For internal use only. This parses one address subsection and puts its
  contents in the Address object. 
*/
//	protected native int makeAddressFromMap( KeyValueMap arg1, EntryAddress arg2);

/**  Create a section from the entries settings. 
*/
	protected native int makeSectionFromEntry( Entry arg1, Section arg2);

/**  Update the mirror map after changes of the database. 
*/
	protected native int updateMirrorMap();

/**  Get the entry section of the file. Maybe a NULL pointer if no file is
  opened. 
*/
	protected native Section entrySection();

/**  Called when .data has been cleared or reloaded. 
*/
//	protected native void reloaded( QConfigDB arg1);

/**  Called when the \e file assigned to .data has changed on disk. 
*/
	protected native void dataFileChanged();

/**  Called when the \e file assigned to .config has changed on disk. 
*/
	protected native void configFileChanged();
	public static final int NoError = 0;
	public static final int /**<Noerror = 1;
	public static final int theoperationdidnotfail.*/PermDenied = 2;
	public static final int /**<Accesspermissionsfortheoperationarenotavailable.*/Locked = 3;
	public static final int /**<Anwritingoperationonalockedfilewasrequested.*/Rejected = 4;
	public static final int /**<Therequestedoperationhasbeenrejectedbytheuser.*/NoSuchEntry = 5;
	public static final int /**<Anentryhasbeenreferencedusingaunknownkey.*/NoEntry = 6;
	public static final int /**<Youtriedtoretrieveanentrybutthereisnone.*/NoFile = 7;
	public static final int /**<Nofilehasbeenloadedbynow.*/NoSuchFile = 8;
	public static final int /**<Afilenamecouldnotbefoundonthefilesystem.*/InternError = 9;
	public static final int /**<Aerrorinkab'sinternallogicoccured.*/OutOfRange = 10;
	public static final int /**<Anindexvaluewasoutoftheallowedrange.*/NoSuchField = 11;
	public static final int /**<Youqueriedafieldthatdoesnotexist.*/NotImplemented/**<Therequestedoperationisnotimplemented.*/ = 12;
	public static final int NoTelephone = 0;
	public static final int Fixed = 1;
	public static final int Mobile = 2;
	public static final int Fax = 3;
	public static final int Modem = 4;
	public static final int User1 = 5;
	public static final int User2 = 6;
	public static final int User3 = 7;
	public static final int NoOfTelephoneTypes = 8;
}
