/***************************************************************************
                            KJScript.java -  description
                             -------------------
    begin                : Sun Aug 26 09:45:02 2001
    copyright            : (C) 2000-2001 Lost Highway Ltd.
    email                : Richard_Dale@tipitina.demon.co.uk
    generated by         : duke@tipitina on Sun Aug 26 09:45:02 2001, using kdoc parser/custom Java conversion backend.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
***************************************************************************/

package org.kde.koala;

import org.kde.qt.*;
import java.util.*;
import java.lang.Error;

/**


 @short ECMAScript interpreter.
*/
public class  KJScript implements QtSupport {
	private long _qt;
	private boolean _allocatedInJavaWorld = true;

	protected KJScript(Class dummy){}


/** 
 Create a new ECMAScript interpreter. You can later ask it to interprete
 code by passing it via {@link #evaluate.}
   
*/
	private native void newKJScript();
	public KJScript() {
		newKJScript();
	}

/** 
  Destructor
   
*/
	protected native void finalize() throws InternalError;

/** 
 Force a "context switch". You usually do not need to do that,
 evaluate() does it too.
   
*/
	public native void init();

/** 
 Returns a pointer to the Global object.
   
*/
	public native int globalObject();

/** 
 Current level of recursive calls to this interpreter. 0 initially.
   
*/
	public native int recursion();

/** 
 Asks the interpreter to evaluate a piece of code. If called more than
 once the state (global variables, functions etc.) will be preserved
 between each call.

*/
	public native boolean evaluate( String code);

/** 
 Same as above. Only differing in the arguments accepted.

*/
//	public native boolean evaluate( KJS_KJSO thisV, char code, int length);

/** 
 Added for convenience in case you have the code in available in
 internal representation already.

*/
//	public native boolean evaluate( KJS_UString code);

/** 
 Call the specified function directly, optionally passing args as a
 list of arguments. Return value and treatment of errors is analog
 to the evaluate() calls.
   
*/
//	public native boolean call( KJS_UString func, int args);
//	public native boolean call( KJS_KJSO scope, KJS_UString func, int args);
//	public native boolean call( KJS_KJSO func, KJS_KJSO thisV, int args, int extraScope);

/** 
 Clear the interpreter's memory. Otherwise, function declarations
 and global variables will be remembered after each invokation of
 {@link KJScript#evaluate}.
   
*/
	public native void clear();

/** 

*/
	public native int returnValue();

/** 

*/
	public native int errorType();

/** 

*/
	public native int errorLine();

/** 

*/
	public native String errorMsg();

/** 
 Check the syntax of a piece of code. Return true if the code could be
 parsed without errors, false otherwise. {@link #errorLine} will tell you
 approximately where the syntax error happened.
   
*/
//	public native boolean checkSyntax( KJS_UString code);

/** 
 Adds a debug() function to the set of pre-defined properties.
 debug(arg) tries to convert 'arg' to a string and prints the result
 to stderr. If you want to debug self defined Host Objects this way
 you should provide them with a toString() method that returns a string.
   
*/
	public native void enableDebug();

/** 
 Don't use. May disappear.
   
*/
	public static native KJScript current();

/** 
 Don't use. May disappear.
   
*/
	public static native void setCurrent( KJScript newCurr);
}
