/***************************************************************************
                            KShellProcess.java -  description
                             -------------------
    begin                : Sun Aug 26 09:45:02 2001
    copyright            : (C) 2000-2001 Lost Highway Ltd.
    email                : Richard_Dale@tipitina.demon.co.uk
    generated by         : duke@tipitina on Sun Aug 26 09:45:02 2001, using kdoc parser/custom Java conversion backend.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
***************************************************************************/

package org.kde.koala;

import org.kde.qt.*;
import java.util.*;
import java.lang.Error;

/**

 This class is similar to {@link KProcess}. The only difference is that
 KShellProcess runs the specified executable through a UNX shell so
 that standard shell mechanisms like wildcard matching, use of pipes
 and environment variable expansion will work.

 For example, you could run commands like the following through
 KShellProcess:

 <pre>
   ls ~/HOME/ .lyx | sort | uniq |wc -l
 </pre>

 KShellProcess tries really hard to find a valid executable shell. Here
 is the algorithm used for finding an executable shell:

 See {@link KShellProcessSignals} for signals emitted by KShellProcess.

 See {@link KShellProcessEventHandling} for event handlers to override in subclasses of KShellProcess.

 @author Christian Czezakte <e9025461@student.tuwien.ac.at>

 @version $Id: KShellProcess.java,v 1.3.2.1 2001/08/29 23:14:10 rdale Exp $

 @short A class derived from @ref KProcess to start child
   	processes through a shell.

*/
public class KShellProcess extends KProcess  {
	protected KShellProcess(Class dummy){super((Class) null);}


/** 
      Constructor

      By specifying the name of a shell (like "/bin/bash") you can override
      the mechanism for finding a valid shell as described in the detailed
      description of this class.
  
*/
	private native void newKShellProcess( String shellname);
	public KShellProcess( String shellname) {
		super((Class) null);
		newKShellProcess( shellname);
	}
	private native void newKShellProcess();
	public KShellProcess() {
		super((Class) null);
		newKShellProcess();
	}

/** 
 Descructor.
   
*/
	protected native void finalize() throws InternalError;

/** 
    Starts up the process. -- For a detailed description
    have a look at the "start" member function and the detailed
    description of {@link KProcess} .
  
*/
	public native boolean start( int runmode, int comm);
	public native boolean start();

/** 
 This function can be used to quote an argument string such that
 the shell processes it properly. This is e. g. necessary for
 user-provided file names which may contain spaces or quotes.
 It also prevents expansion of wildcards and environment variables.
   
*/
	public static native String quote( String arg);
}
