/***************************************************************************
                            KStringHandler.java -  description
                             -------------------
    begin                : Sun Aug 26 09:45:02 2001
    copyright            : (C) 2000-2001 Lost Highway Ltd.
    email                : Richard_Dale@tipitina.demon.co.uk
    generated by         : duke@tipitina on Sun Aug 26 09:45:02 2001, using kdoc parser/custom Java conversion backend.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
***************************************************************************/

package org.kde.koala;

import org.kde.qt.*;
import java.util.*;
import java.lang.Error;

/**
 General description of this class:

 This class is <em>not</em> a substitute for the {@link String} class. What
 I tried to do with this class is provide an easy way to
 cut/slice/splice words inside sentences in whatever order desired.
 While the main focus of this class are words (ie characters
 separated by spaces/tabs), the two core functions here ({@link #split}
 and {@link #join} ) will function given any char to use as a separator.
 This will make it easy to redefine what a 'word' means in the
 future if needed.

 I freely stole some of the function names from python. I also think
 some of these were influenced by mIRC (yes, believe it if you will, I
 used to write a LOT of scripts in mIRC).

 The ranges are a fairly powerful way of getting/stripping words from
 a string. These ranges function, for the large part, as they would in
 python. See the {@link word} and {@link remword} functions for more detail.

 This class contains no data members of it own. All strings are cut
 on the fly and returned as new qstrings/qstringlists.

 Quick example on how to use:

 <pre>
 KStringHandler kstr;
 String line = "This is a test of the strings";

 cout << "1> " << kstr.word( line , "4:" ) << "\n";
 cout << "2> " << kstr.remrange( line , "2:5" ) << "\n";
 cout << "2> " << kstr.reverse( line ) << "\n";
 cout << "2> " << kstr.center( kstr.word( line , 4 ) , 15 ) << "\n";
 </pre>

 and so forth.

 @author Ian Zepp <icszepp@islc.net>
 
 @short Class for manipulating words and sentences in strings.
*/
public class  KStringHandler implements QtSupport {
	private long _qt;
	private boolean _allocatedInJavaWorld = true;

	protected KStringHandler(Class dummy){}


/**  Returns the nth word in the string if found
 Returns a EMPTY (not null) string otherwise.
 Note that the FIRST index is 0
      
*/
	public static native String word( String text, int pos);

/**  Returns a range of words from that string.
 Ie:

 "0"        returns the very first word
 "0:"    returns the first the the last word
 "0:3"    returns the first to fourth words
 ":3"    returns everything up to the fourth word

 If you grok python, you're set.
      
*/
	public static native String word( String text, String range);

/**  Inserts a word into the string, and returns
 a new string with the word included. the first
 index is zero (0)
      
*/
	public static native String insword( String text, String word, int pos);

/**  Replaces a word in the string, and returns
 a new string with the word included. the first
 index is zero (0)
      
*/
	public static native String setword( String text, String word, int pos);

/**  Removes a word or ranges of words from the string,
 and returns a new string. The ranges definitions
 follow the definitions for the word() function.

 "0"        removes the very first word
 "0:"    removes the first the the last word
 "0:3"    removes the first to fourth words
 ":3"    removes everything up to the fourth word
      
*/
	public static native String remrange( String text, String range);

/**  Removes a word at the given index, and returns a
 new string. The first index is zero (0)
      
*/
	public static native String remword( String text, int pos);

/**  Removes a matching word from the string, and returns
 a new string. Note that only ONE match is removed.
      
*/
	public static native String remword( String text, String word);

/**  Capitalizes each word in the string
 "hello there" becomes "Hello There"        (string)
      
*/
	public static native String capwords( String text);

/**  Capitalizes each word in the list
 [hello, there] becomes [Hello, There]    (list)
      
*/
	public static native ArrayList capwords( String[] list);

/**  Reverses the order of the words in a string
 "hello there" becomes "there hello"        (string)
      
*/
	public static native String reverse( String text);

/**  Reverses the order of the words in a list
 [hello, there] becomes [there, hello]    (list)
      
*/
	public static native ArrayList reverse( String[] list);

/**  These string justify a string along x, and returns a
 string at least 'width' characters wide, and justified.
 If the string is longer than the width, the original
 string is returned. It is never truncated.
 ljust    Left justify
 rjust    Right justify
 center    Centers
      
*/
	public static native String ljust( String text, int width);
	public static native String rjust( String text, int width);
	public static native String center( String text, int width);

/**  Substitute characters at the beginning of a string by "...".

*/
	public static native String lsqueeze( String str, int maxlen);

/**  Substitute characters at the middle of a string by "...".

*/
	public static native String csqueeze( String str, int maxlen);

/**  Substitute characters at the end of a string by "...".

*/
	public static native String rsqueeze( String str, int maxlen);

/** 

*/
	public static native boolean matchFilename( String filename, String pattern);

/** 
 Split a String into a StringList in a similar fashion to the static
 StringList function in Qt, except you can specify a maximum number
 of tokens. If max is specified (!= 0) then only that number of tokens
 will be extracted. The final token will be the remainder of the string.

 Example:
 perlSplit("__", "some__string__for__you__here", 4)
 StringList contains: "some", "string", "for", "you__here"

*/
//	public static native ArrayList perlSplit( String sep, String s, int max);

/** 
 Split a String into a StringList in a similar fashion to the static
 StringList function in Qt, except you can specify a maximum number
 of tokens. If max is specified (!= 0) then only that number of tokens
 will be extracted. The final token will be the remainder of the string.

 Example:
 perlSplit(' ', "kparts reaches the parts other parts can't", 3)
 StringList contains: "kparts", "reaches", "the pats other parts can't"

*/
	public static native ArrayList perlSplit( char sep, String s, int max);

/** 
 Split a String into a StringList in a similar fashion to the static
 StringList function in Qt, except you can specify a maximum number
 of tokens. If max is specified (!= 0) then only that number of tokens
 will be extracted. The final token will be the remainder of the string.

 Example:
 perlSplit(QRegExp("[! ]", "Split me up ! I'm bored ! OK ?", 3)
 StringList contains: "Split", "me", "up ! I'm bored, OK ?"

*/
//	public static native ArrayList perlSplit( QRegExp sep, String s, int max);
}
