/* ****************************************************************************
  This file is part of KBabel

  Copyright (C) 2002 by Stanislav Visnovsky
			    <visnovsky@kde.org>

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

**************************************************************************** */
#ifndef KBCHARSELECT_H
#define KBCHARSELECT_H

#include <qvbox.h>

class KConfig;
class KCharSelectTable;
class QSpinBox;

class KBCharSelect : public QVBox
{
   Q_OBJECT
public:
   KBCharSelect(QWidget* parent, const char* name=0);
   
   void saveSettings(KConfig* config);
   void restoreSettings(KConfig* config);

signals:
   void characterDoubleClicked( QChar ch );

public slots:
   void emitChar();

private slots:
   void setTab( int value);
   
private:
   KCharSelectTable* _table;
   QSpinBox* _tableNum;
};

#endif // KBCHARSELECT_H
