/* This file is part of the Keep project
   Copyright (C) 2005 Jean-Rémy Falleri <jr.falleri@laposte.net>

   Keep is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   Keep is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with Keep; if not, write to the
   Free Software Foundation, Inc.,
   51 Franklin Steet, Fifth Floor, Boston, MA 02110-1301, USA.           */

#include "advancedbackupconfigdialog.h"

#include <klocale.h>
#include <qlayout.h>
#include <kurl.h>
#include <dcopref.h>
#include <kdebug.h>
#include <kactivelabel.h>
#include <kmimetype.h>
#include <qpixmap.h>
#include <kapplication.h>
#include <kiconloader.h>
#include <qstringlist.h>
#include <kactionselector.h>

AdvancedBackupConfigDialog::AdvancedBackupConfigDialog(QWidget *parent):KDialogBase(Plain, i18n("Advanced Backup Configuration"),
	Help|Ok, Ok, parent, "advancedBackupConfigDialog", true, false)
{
	QGridLayout *topLayout = new QGridLayout(plainPage());
	m_advancedBackupConfigView = new AdvancedBackupConfigView(plainPage());

	topLayout->addWidget( m_advancedBackupConfigView,0,0 );
	m_advancedBackupConfigView->optionList->availableListBox()->insertStringList(allOptionList());
	resize( QSize(350,450).expandedTo(minimumSizeHint()) );
}

QStringList AdvancedBackupConfigDialog::optionList()
{
	QStringList options;
	for (uint i=0;i<m_advancedBackupConfigView->optionList->selectedListBox()->count();i++)
	{
		options.append(m_advancedBackupConfigView->optionList->selectedListBox()->text(i));
	}
	return options;
}

void AdvancedBackupConfigDialog::setOptionList(QStringList optionList)
{
	QStringList alloptions = allOptionList();
	QStringList available;
	for ( QStringList::Iterator it = alloptions.begin(); it != alloptions.end(); ++it )
	{
		if ( optionList.grep(*it).size() == 0 )
		{
			available.append(*it);
		}
	}
	m_advancedBackupConfigView->optionList->availableListBox()->clear();
	m_advancedBackupConfigView->optionList->availableListBox()->insertStringList(available);
	m_advancedBackupConfigView->optionList->selectedListBox()->clear();
	m_advancedBackupConfigView->optionList->selectedListBox()->insertStringList(optionList);
}

QStringList AdvancedBackupConfigDialog::allOptionList()
{
	QStringList options;
	options.append("--no-hard-links");
	options.append("--exclude-special-files");
	options.append("--exclude-device-files");
	options.append("--exclude-fifos");
	options.append("--exclude-symbolic-links");
	options.append("--exclude-sockets");
	options.append("--never-drop-acls");
	options.append("--no-compare-inode");
	options.append("--no-file-statistics");
	options.append("--preserve-numerical-ids");
	options.append("--ssh-no-compression");
	options.append("--no-compression");
	options.append("--include-special-files");
	options.append("--include-symbolic-links");
	return options;
}

#include "advancedbackupconfigdialog.moc"
