/***********************************************************************
**
**   flightrecorderpluginbase.cpp
**
**   This file is part of KFLog2.
**
************************************************************************
**
**   Copyright (c):  2003 by Andr Somers
**
**   This file is distributed under the terms of the General Public
**   Licence. See the file COPYING for more information.
**
**   $Id: flightrecorderpluginbase.cpp,v 1.3 2003/05/27 20:57:03 eggert Exp $
**
***********************************************************************/

#include "flightrecorderpluginbase.h"

FlightRecorderPluginBase::FlightRecorderPluginBase(){
  _isConnected=false;
  _errorinfo="";

  //initialize capabilities to none. This class is never instanciated, so this could be skipped
  _capabilities.maxNrTasks = 0;             //maximum number of tasks
  _capabilities.maxNrWaypoints = 0;         //maximum number of waypoints
  _capabilities.maxNrWaypointsPerTask = 0;  //maximum number of waypoints per task
  _capabilities.maxNrPilots = 0;            //maximum number of pilots

  _capabilities.supDlWaypoint = false;      //supports downloading of waypoints?
  _capabilities.supUlWaypoint = false;      //supports uploading of waypoints?
  _capabilities.supDlFlight = false;        //supports downloading of flights?
  _capabilities.supUlFlight = false;        //supports uploading of flights?
  _capabilities.supSignedFlight = false;    //supports downloading in of signed flights?
  _capabilities.supDlTask = false;          //supports downloading of tasks?
  _capabilities.supUlTask = false;          //supports uploading of tasks?
  _capabilities.supUlDeclaration = false;   //supports uploading of declarations?
  _capabilities.supDspPilotName = false;    //supports display of pilot name
  _capabilities.supDspRecorderType = false; //supports display of recorder type
  _capabilities.supDspSerialNumber = false; //supports display of serial number
  _capabilities.supDspGliderID = false;     //supports display of glider ID
  _capabilities.supDspGliderType = false;   //supports display of glider type
  _capabilities.supDspCompetitionID = false;//supports display of competition ID
}


FlightRecorderPluginBase::~FlightRecorderPluginBase(){
}

/**
 * Returns additional info about an error that occured (optional).
 * _errorinfo is reset afterwards.
 */
QString FlightRecorderPluginBase::lastError(){
  QString ret=_errorinfo;
  _errorinfo="";
  return ret;
}
