\ adio.4th
\
\ Acquire data from a B&B Electronics ADIO12 
\   8 Channel 12-bit Analog/Digital Converter
\   to Parallel Port Interface
\
\ Copyright (c) 2001  K. Myneni, Provided under
\	the GNU General Public License
\
\ Revisions:
\	Created  27 June 2001
\
\ Notes:
\
\   1. The computer must have a bi-directional parallel port.
\   2. Must be root to access /dev/port or user must be given
\        system privelage when running kForth: chmod a+s kforth
\
\
base @ 
hex
002 constant O_RDWR
378 constant port	\ Change this if your port address is different
0 port + constant port_base
1 port + constant port_status
2 port + constant port_control

1 constant CONVERSION_TIMEOUT	\ timeout for end of conversion in seconds

variable ppfd
variable cmd  \ the data register value
variable temp

: read_port ( n -- m | read a byte from port n )
	ppfd @ swap 0 lseek drop
	ppfd @ temp 1 read drop
	temp c@ ;

: write_port ( m n -- | write byte value m to port n )
	ppfd @ swap 0 lseek drop
	temp c!
	ppfd @ temp 1 write drop ;
	
: write_base_reg ( -- | write byte from cmd to the base register )
	cmd @ port_base write_port ;
	
: open_adio ( -- | open the port driver to access the adio )
	c" /dev/port" O_RDWR open dup ppfd !
	0< if
	  ." Error opening /dev/port --- check permissions." cr
	  exit
	then
 
	1 6 lshift cmd c! \ set internal clock mode 
			  \ initial input range is 0 to 5 V
	write_base_reg ;
  
: set_acq_mode ( b -- | set acquisition mode )
	\ b is true for "internal acquisition mode"
	\      false for "external acquisition mode"
	1 5 lshift swap
	if
	  not cmd c@ and
	else
	  cmd c@ or
	then
	cmd c!
	write_base_reg ;

: set_channel ( n -- | set the analog input channel )
	7 and  \ mask lower three bits 
	cmd c@ 7 not and  \ clear lower three bits of cmd
	or cmd c!
	write_base_reg ;

: set_input_range ( n -- | set the voltage range )
	\ n selects the input range and may be one of the following:
	\	0  ==> 0 to +5 V
	\	1  ==> -5 to +5 V
	\	2  ==> 0 to +10 V
	\	3  ==> -10 to +10 V

	3 and 3 lshift
	cmd c@ 3 3 lshift not and
	or cmd c!
	write_base_reg ;

: secs ( -- n | current clock seconds )
	time&date 2drop 2drop drop ;

: ?timeout ( n -- b | given start seconds, return true if timeout elapsed )
	secs swap - dup
	0< if 60 + then			\ check for clock wraparound
	CONVERSION_TIMEOUT >= ;
	
: convert ( -- n | complete a single conversion and return the value )
	write_base_reg			\ set configuration

	\ Start the A/D conversion

	8 port_control write_port	\ set /WR low, /RD high
	0 port_control write_port	\ set /WR high, /RD high

	\ Wait for the conversion to complete

	1 ms	\ just wait 1 ms;
		\ the following code to monitor for end of conv. doesn't work
	\ secs
	\ begin
	\  port_status read_port
	\  6 rshift 1 and		\ /INT line low?
	\  over ?timeout or		\ have we timed out?
	\ until
	\ drop

	\ Read the 12 data bits

	22 port_control write_port	\ set /RD low, HBEN high, DIR=input
	port_base read_port 8 lshift	\ read upper 4 bits
	23 port_control write_port	\ set HBEN low, DIR=input
	port_base read_port		\ read lower 4 bits
	or 
	0 port_control write_port 	\ reset DIR=output
	temp ! temp w@			\ sign extend the number
;

: close_adio ( -- )
	ppfd @ close drop ;

base !

: show_adio ( -- | measure and display the 8 channels )
	open_adio
	\ 2 set_input_range   ( uncomment this line for 0 to 10 V range )
	8 0 do 
	  i set_channel
	  convert
	  i 2 .r 2 spaces . cr
	loop
	close_adio ;
	
