\ serbuf.4th
\
\ Determine the size of the serial port
\ driver's input buffer. The port should
\ be connected to a source of data at
\ 9600 baud N81.
\
\ K. Myneni, 4-20-2001
\
\ Requires:
\	strings.4th
\	serial.4th
\
\ Revisions:
\

include strings
include serial

cr cr
." Usage: com1 serbuf, com2 serbuf, etc." cr cr
." The test will take a few seconds (>10). It will display the driver's" cr
." buffer size. Ensure that you have a transmitting data source on the" cr
." com port and that the transmitter is configured for 9600 N81." cr cr

10 constant MAX_TRIES	\ number of succesive measurements to have same count
1000 constant INTERVAL	\ measurement interval in ms

variable com
variable last_count
variable count
variable ntries

: serbuf ( port -- | print the port's buffer size )
	serial_open com !
	com @ c" 8N1" serial_setparams
	com @ B9600 serial_setbaud
	0 last_count !
	0 ntries !
	begin
	  com @ serial_lenrx count ! 
	  count @ last_count @ = 
	  if
	    1 ntries +!
	    ntries @ MAX_TRIES = 
	    if
	      \ flush the buffer, close the port, and end the test
	      com @ serial_flush
	      com @ serial_close drop
	      cr
	      count @ 0<>
	      if
	        ." Buffer size = " count @ . cr
	      else
	        ." Did not receive any data!" cr
	      then
	      exit
	    then
	  else
	    count @ last_count !
	  then
	  count @ . 
	  INTERVAL ms
	again ;

