\ stats.4th
\
\ Copyright (c) 1998--2003 Krishna Myneni
\ Revisions:
\ 
\	12-22-1998
\	2003-11-06  added probability density function calculations:
\		      PGAUSS, AGAUSS, AREA_GAUSS  km
\
\ Compute the mean and variance of a set of floating point numbers
\
\ Example:	1.3e 3.4e 2.1e 1.9e 4 stats
\
\ The words "mean", "variance", and "stats" expect on the stack
\ a series of floating point numbers followed by the integer count:
\
\	f1 f2 ... fn n --
\
\ This sequence is referred to as an "frc" (floating point row or column). 
\ 
\ Requires:
\
\	matrix.4th
\


fvariable mu
fvariable sigma2

: mean ( frc -- fmu | compute mean )
	0e rot dup >r 
	0 do f+ loop 
	r> s>f f/ 
	fdup mu f! ;

: variance ( frc -- fsigma2 | compute variance )
	dup >r 
	frc_dup mean
	rot 0e rot 
	0 do >r >r fdup frot f- fdup f* r> r> f+ loop
	fswap fdrop 
	r> 1- s>f f/ 
	fdup sigma2 f! ;

: stats ( frc -- | compute and print the statistics )
	variance
	mu f@ cr 
	." Mean = " f. cr
	." Variance = " f. cr ;
	
	
\ The words pgauss and agauss are translated from corresponding
\ Fortran functions in P.R. Bevington, Data Reduction and Error 
\ Analysis for the Physical Sciences, 1969, McGraw-Hill.

: pgauss ( fx fmu fsigma -- fpdf | evaluate gaussian probability density at fx)
       fdup f0= ABORT" PGAUSS: zero sigma value"
       2>r f- 2r@ f/ fdup f* 2e f/ fnegate fexp
       0.3989422804e f* 2r> f/ ;

\ Evaluate area between the limits (mu - z*sigma) to (mu + z*sigma)
\   where z = |x-mu|/sigma, e.g. if mu = 0, the area is computed
\   between -x and +x.  

fvariable agauss_term
fvariable agauss_sum
fvariable agauss_denom

: agauss ( fx fmu fsigma -- farea )
       fdup  f0= ABORT" AGAUSS: zero sigma value"
       2>r f- 2r> f/ fabs			\ -- z
       fdup  0e f<= IF fdrop 0e exit THEN	\ -- z
       fdup  0.7071067812e f*			\ -- z term
       fdup  agauss_term f! agauss_sum f!	\ -- z
       fdup  f* 2e f/				\ -- y2		
       
       \ Accumulate sum of terms

       1e agauss_denom f!

       BEGIN
         fdup 2e f*					\ -- y2 2*y2
         agauss_denom f@ 2e f+ fdup agauss_denom f! f/	\ -- y2 2*y2/denom
	 agauss_term f@ f* fdup				
	 agauss_sum f@ f+ agauss_sum f!
	 fdup agauss_term f!
	 agauss_sum f@ f/ 1e-10 f<=
       UNTIL

       fnegate fexp agauss_sum f@ f* 1.128379167e f*
;
	 
\ Return area between x1 and x2 for Gaussian probability density function

fvariable agauss_mu
fvariable agauss_sigma

: area_gauss ( fx1 fx2 fmu fsigma -- farea )
    fdup f0= ABORT" AREA_GAUSS: zero sigma value" 
    agauss_sigma f! 
    agauss_mu f!			\ -- fx1 fx2
    agauss_mu f@  f-  fswap 
    agauss_mu f@  f-  fswap		\ -- fx1-fmu  fx2-fmu
    fover fover f* 0e f>  >r 
    fabs  0e  agauss_sigma f@  agauss  fswap
    fabs  0e  agauss_sigma f@  agauss
    r>
    IF    f- fabs		       \ (x1-mu) and (x2-mu) have same sign?
    ELSE  f+			       \ (x1-mu) and (x2-mu) have opposite sign
    THEN  2e f/   
;

(  
\ Test code for Gaussian probability functions

: test_gauss \ -- | print a table of values for mu = 0, sigma =1
    0e
    BEGIN
      cr
      fdup f. 2 spaces 
      fdup 0e 1e pgauss f. 2 spaces
      fdup 0e 1e agauss f. 2 spaces
      fdup fnegate fover 0e 1e area_gauss f.
      0.1e f+ 
      fdup 3e f>
    UNTIL
    fdrop cr ;
)




