\ gpib.4th
\
\ kForth Interface words for the Linux GPIB driver
\ developed by Claus Schroeter, which can be found
\ at the Linux Lab Project website ().
\
\ Copyright (c) 1999 Krishna Myneni
\ Provided under the terms of the GNU General Public License
\
\ Revisions:
\ 
\	3-22-1999  first working version
\	3-23-1999  completed port of UR/FORTH GPIB driver
\	5-20-1999  added C_IBTMO and ibtmo timeout words; set
\                  default timeout to 3 seconds.

variable gpib_driver
" /dev/gpib0/master" gpib_driver ! 

0 constant C_IBRD
1 constant C_IBWRT
2 constant C_IBCMD
3 constant C_IBWAIT
4 constant C_IBRPP
5 constant C_IBONL
6 constant C_IBSIC
7 constant C_IBSRE
8 constant C_IBGTS
9 constant C_IBCAC
14 constant C_IBTMO

100 constant DVTRG
101 constant DVCLR
102 constant DVRSP
103 constant DVRD
104 constant DVWRT

variable gpib_fd

create ibargs 8 4 * allot
0 constant OF_IB_CNT
4 constant OF_IB_ARG
8 constant OF_IB_RET
12 constant OF_IB_IBSTA
16 constant OF_IB_IBERR
20 constant OF_IB_IBCNT
24 constant OF_IB_BUF

create ibcmd_buf 64 allot
create gpib_in_buf 16384 allot
create gpib_out_buf 16384 allot

: open_gpib ( -- ior | open the gpib device driver )
	gpib_driver a@ 2 open dup gpib_fd ! 0 < ;

: close_gpib ( -- | close the device driver )
	gpib_fd @ close drop ;

: ibsta ( -- status | return status of last gpib function )
	ibargs OF_IB_IBSTA + @ ;

: iberr ( -- error | return error code of last gpib function )
	ibargs OF_IB_IBERR + @ ;

: ibcnt ( -- count | return count from last gpib function )
	ibargs OF_IB_IBCNT + @ ;

: ibonl ( onl -- | place the gpib online/offline )
	ibargs OF_IB_ARG + !
	gpib_fd @ C_IBONL ibargs ioctl drop ;

: ibsic ( -- | send interface clear on gpib0 )
	gpib_fd @ C_IBSIC ibargs ioctl drop ;

: ibsre ( v -- | set or clear remote enable line )
	ibargs OF_IB_ARG + !
	gpib_fd @ C_IBSRE ibargs ioctl drop ;

: ibtmo ( v -- | set timeout to v )
	\ v: 0 = disabled, 1 = 10 usec, 2 = 30 usec, 3 = 100 usec,
	\    4 = 300 usec, 5 = 1 msec, 6 = 3 msec, 7 = 10 msec,
	\    8 = 30 msec, 9 = 100 msec, 10 = 300 msec, 11 = 1 sec,
	\    12 = 3 sec, 13 = 10 sec, 14 = 30 sec, 15 = 100 sec
	ibargs OF_IB_ARG + !
	gpib_fd @ C_IBTMO ibargs ioctl drop ;

: init_gpib ( -- | initialize the gpib board and interface )
	1 ibonl
	ibsic
	1 ibsre 
	12 ibtmo ;

: ibcmd ( c_n ... c_2 c_1 n -- ibsta | send command bytes to gpib )
	dup ibargs OF_IB_CNT + !
  	0 do ibcmd_buf i + c! loop
	ibcmd_buf ibargs OF_IB_BUF + !
	0 ibargs OF_IB_ARG + !
	gpib_fd @ C_IBCMD ibargs ioctl drop ibsta ;

: clear_device ( n -- | send SDC to device at address n )
	4 swap 32 + 64 3 ibcmd drop ;


: ibrd2 ( buf n -- | read n bytes into buf )
	ibargs OF_IB_CNT + !
	ibargs OF_IB_BUF + !
	gpib_fd @ C_IBRD ibargs ioctl drop ;

: ibwrt2 ( buf n -- | write n bytes from buf )
	ibargs OF_IB_CNT + !
	ibargs OF_IB_BUF + !
	gpib_fd @ C_IBWRT ibargs ioctl drop ;


: send_command ( addr n  -- | send byte sequence to dev n )     
   \ addr is the address of a counted string containing         
   \ the byte sequence.                                         
   \ n is the primary address of the device
                                                
    32 + 64 2 ibcmd drop      \ set talker and listener         
    count ibwrt2              \ write data                      
    95 63 2 ibcmd drop ;      \ untalk and unlisten             


: send_bytes ( m n -- | send m bytes to device n )              
                                                                
    \ This word is similar to send_command except that          
    \ it operates on the output buffer gpib_out_buf            
    \ rather than a counted string.                             
    \ m is the number of bytes to send from gpib_out_buf.      
    \ n is the primary address of the device.                   
                                                                
    32 + 64 2 ibcmd drop       \ set talker and listener        
    gpib_out_buf swap ibwrt2  \ write data                     
    95 63 2 ibcmd drop ;       \ untalk and unlisten       


: read_bytes ( m n -- | read m bytes from dev n )               
    \ n is the primary address of the device                    
    \ m bytes are stored in gpib_in_buf                        
                                                                
    64 + 32 2 ibcmd drop       \ set listener and talker        
    gpib_in_buf swap ibrd2     \ read data                      
    63 95 2 ibcmd drop ;       \ untalk and unlisten            

