# This file is part of khmer, https://github.com/dib-lab/khmer/, and is
# Copyright (C) 2011-2015, Michigan State University.
# Copyright (C) 2015-2016, The Regents of the University of California.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions are
# met:
#
#     * Redistributions of source code must retain the above copyright
#       notice, this list of conditions and the following disclaimer.
#
#     * Redistributions in binary form must reproduce the above
#       copyright notice, this list of conditions and the following
#       disclaimer in the documentation and/or other materials provided
#       with the distribution.
#
#     * Neither the name of the Michigan State University nor the names
#       of its contributors may be used to endorse or promote products
#       derived from this software without specific prior written
#       permission.
#
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
# "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
# LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
# A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
# HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
# SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
# LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
# DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
# THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
# (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
# OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
#
# Contact: khmer-project@idyll.org
# pylint: disable=missing-docstring
from __future__ import print_function, unicode_literals

import khmer
import pytest


@pytest.mark.jenkins
def test_python_and_c_match():
    """checks c++ compiler option version against versioneer version"""
    print('c++ version {0}:'.format(khmer.__version_cpp__()))
    print('versioneer (python) version: {0}'.format(khmer.__version__))
    assert khmer.__version_cpp__() == khmer.__version__


def test_python_and_c_match_base():
    # same as above but strips off the last part which can cause problems as
    # it's a hash based on git commits which can get out-of-sync too easily
    cppver = '-'.join(khmer.__version_cpp__().split('-')[0:2])
    pyver = '-'.join(khmer.__version__.split('-')[0:2])
    print('c++ version {0}'.format(cppver))
    print('python version: {0}'.format(pyver))
    print('if you are seeing this, the version compiled into your cpp')
    print('objects and your versioneer stuff is out-of-sync.')
    print('try doing: make clean; make')
    assert cppver == pyver
