/*
  Copyright Mission Critical Linux, 2000

  Kimberlite is free software; you can redistribute it and/or modify it
  under the terms of the GNU General Public License as published by the
  Free Software Foundation; either version 2, or (at your option) any
  later version.

  Kimberlite is distributed in the hope that it will be useful, but
  WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with Kimberlite; see the file COPYING.  If not, write to the
  Free Software Foundation, Inc.,  675 Mass Ave, Cambridge, 
  MA 02139, USA.
*/
/*
 * $Id: cluadmin.h,v 1.3 2000/06/24 23:52:35 lawrence Exp $
 *
 * Copyright (C) 2000, Mission Critical Linux, LLC
 *
 * Author: Jeff Moyer <moyer@mclinux.com>
 * Description: Protocol headers for the cluster admin utility.
 */
#ifndef __MCL_CLUADMIN_H
#define __MCL_CLUADMIN_H
#ifdef __cplusplus
extern "C" {
#endif

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#define MAX_ADMIN_MSGLEN _POSIX_SSIZE_MAX  /* 32767 */
#define MAX_IPC_MSGLEN   MAX_ADMIN_MSGLEN - sizeof(struct admin_msg_hdr)

/*
 * One lonely prototype.
 */
void *send_request(char *hostname, short port,
		   int procid, void *buf, size_t count);



#define ADMIND_MSG_MAGIC  0xcbd0425a /* courtesy of /dev/random */

struct admin_msg_hdr {
    unsigned long magic;
    int           dest; /* PROCID_XXX */
    size_t        sz;
};


#ifdef __cplusplus
}
#endif
#endif /* __MCL_CLUADMIN_H */
