/*
  Copyright Mission Critical Linux, 2000

  Kimberlite is free software; you can redistribute it and/or modify it
  under the terms of the GNU General Public License as published by the
  Free Software Foundation; either version 2, or (at your option) any
  later version.

  Kimberlite is distributed in the hope that it will be useful, but
  WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with Kimberlite; see the file COPYING.  If not, write to the
  Free Software Foundation, Inc.,  675 Mass Ave, Cambridge, 
  MA 02139, USA.
*/
/*
 * $Id: diskcomms.h,v 1.4 2000/07/14 14:10:06 moyer Exp $
 */
#ifndef __QUORUMDCOMMS_H
#define __QUORUMDCOMMS_H

#ifdef __cplusplus
extern "C" {
#endif

#include <msgsvc.h>


/*
 * State associated with each connection:
 */

typedef struct connectionStruct {
    int                      fd;
    int                      offset;
    int                      secure;
    DiskMessageSt            msg;
    struct connectionStruct  *prev;
    struct connectionStruct  *next;
} quorumdConnectionSt;


/*
 *  Linked list operations
 */
int quorumdAddConn(int fd);
int quorumdDelConn(quorumdConnectionSt *cnxp);


#ifdef __cplusplus
}
#endif

#endif /* __QUORUMDCOMMS_H */

