/*
  Copyright Mission Critical Linux, 2000

  Kimberlite is free software; you can redistribute it and/or modify it
  under the terms of the GNU General Public License as published by the
  Free Software Foundation; either version 2, or (at your option) any
  later version.

  Kimberlite is distributed in the hope that it will be useful, but
  WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with Kimberlite; see the file COPYING.  If not, write to the
  Free Software Foundation, Inc.,  675 Mass Ave, Cambridge, 
  MA 02139, USA.
*/
/*
 *  $Id: test_lock.c,v 1.8 2000/07/24 14:50:44 moyer Exp $
 *
 *  Copyright (C) 2000 Mission Critical Linux, LLC
 *
 *  author: Dave Winchell <winchell@missioncriticallinux.com>
 *  description: 
 */

#include <stdio.h>
#include <unistd.h>
#include <string.h>
#include <fcntl.h>
#include <sys/types.h>
#include <sys/param.h>
#include <sys/stat.h>
#include <sys/wait.h>
#include <sys/time.h>
#include <sys/errno.h>
#include <signal.h>
#include <sys/mman.h>
#include <stdlib.h>

#include "diskstate.h"
#include "disk_proto.h"
#include "msgsvc.h"
#include <clusterdefs.h>
#include <parseconf.h>
#include <power.h>

#include <sys/file.h>   
#include <errno.h>
#include <clu_lock.h>
#ifdef CLU_LOCK_MULTITHREADED
#include <pthread.h>
#endif

static const char *version __attribute__ ((unused)) = "$Id: test_lock.c,v 1.8 2000/07/24 14:50:44 moyer Exp $";
void test_trash(void);
int trash_disk(int which, off_t writeOffset, int blocks);
int fd = -1;
void *clu_lock_test_buff;
extern int _clu_node_id;
void write_and_check_data(unsigned long int count);
void init_lock_test(void);
void lock_test(void);
void lock_test_1(void);
void lock_test_2(void);
int test_db_1(char *data, ssize_t size);
static int zfd = -1;

extern int sharedPartitionFDinited;
extern int sharedPartitionFD[];
int initSharedFD(void);
#define TEST_BLOCKSIZE (1<<9)

#define TASKS 10
void lock_test_2(void)
{
	pid_t pid;
	int tasks = TASKS;

	init_lock_test();
	while (tasks--) {
		pid = fork();
		if(pid == -1) {
			printf("fork failure, errno = %d\n", errno);
			exit(1);
		}
		else if (pid == 0) {
			lock_test_1();
		}
	}
	tasks = TASKS ;
	while(wait((int *)0)) {
		tasks--;
		if(!tasks)
			break;
	}
}
#ifdef CLU_LOCK_MULTITHREADED
void * lock_test_thread(void *arg)
{
	pthread_t thd;
	unsigned long int count = 0;

	thd = pthread_self();

	while(count < 100) {
		printf("thd = 0x%lx count = 0x%lx\n", thd, count);
		clu_lock();
		write_and_check_data(count);
		clu_un_lock();
	}
}		
#define NUM_THREADS 10
void lock_test_mt(void)
{
	pthread_t thd[10];
	void *ret_val;
	int i, ret;

	init_lock_test();

	for(i=0; i<NUM_THREADS; i++) {
		ret = pthread_create(&thd[i], (pthread_attr_t  *)0, lock_test_thread, (void *)0);
		if(ret) {
			printf("pthread_create failed: %s\n", strerror(errno));
			exit(1);
		}
	}

	for(i=0; i<NUM_THREADS; i++) {
		ret = pthread_join(thd[i], &ret_val);
		if(ret) {
			printf("pthread_join failed: %s\n", strerror(errno));
			exit(1);
		}
	}
}
#endif		


void lock_test(void) {
	init_lock_test();
	lock_test_1();
}
void lock_test_1(void)
{
	pid_t pid;
	unsigned long int count = 0;

	pid = getpid();
	while(1) {
		if(!(count++ % 20)) {
			printf("pid = %d count = 0x%lx\n", pid, count);
		}		
		clu_lock();
		write_and_check_data(count);
		clu_un_lock();
	}
}

void write_and_check_data(unsigned long int count)
{
	int *p;
	ssize_t ret;
	pid_t pid;
#ifdef CLU_LOCK_MULTITHREADED
	pthread_t thd;
#endif

	pid = getpid();
#ifdef CLU_LOCK_MULTITHREADED
	thd = pthread_self();
#endif
	p = (int *)clu_lock_test_buff;
	*p++ = _clu_node_id;
	*p++ = *(int *)&pid;
#ifdef CLU_LOCK_MULTITHREADED
	*(pthread_t *)p = thd;
#endif

	ret = lseek(fd, 0, SEEK_SET);
	if(ret != 0) {
		printf("write_and_check_data: bad ret from lseek, ret = %Zd errno = %d\n",
		       ret, errno);
		exit(1);
	}
	ret = write(fd, clu_lock_test_buff, TEST_BLOCKSIZE);
	if(ret != TEST_BLOCKSIZE) {
		printf("write_and_check_data: bad ret from write, ret = %Zd errno = %d\n",
		       ret, errno);
		exit(1);
	}
	ret = lseek(fd, 0, SEEK_SET);
	if(ret != 0) {
		printf("write_and_check_data: bad ret from lseek, ret = %Zd errno = %d\n",
		       ret, errno);
		exit(1);
	}
	ret = read(fd, clu_lock_test_buff, TEST_BLOCKSIZE);
	if(ret != TEST_BLOCKSIZE) {
		printf("write_and_check_data: bad ret from read, ret = %Zd errno = %d\n",
		       ret, errno);
		exit(1);
	}
	p = (int *)clu_lock_test_buff;
	if(*p != _clu_node_id) {
		printf("failure, count = 0x%lx pid = %d expected = %d read = %d\n",
		       count, pid, _clu_node_id, *p);
		exit(1);
	}
	p++;
	if(*p != pid) {
		printf("failure, count = 0x%lx pid = %d expected = %d read = %d\n",
		       count, pid, pid, *p);
		exit(1);
	}
#ifdef CLU_LOCK_MULTITHREADED
	p++;
	if(*(pthread_t *)p != thd) {
		printf("failure, count = 0x%lx pid = %d expected = 0x%lx read = 0x%lx\n",
		       count, pid, thd, *(pthread_t *)p);
		exit(1);
	}
#endif
}

void init_lock_test(void)
{

	fd = open("/dev/raw3", O_RDWR | O_SYNC);
	if(fd < 0) {
		printf("Can't open /dev/raw3, errno = %d\n", errno);
		exit(1);
	}
	/* this is global for speed in inner loop to make race more likely */
	clu_lock_test_buff = malloc(2*TEST_BLOCKSIZE);
	printf("clu_lock_test_buff = 0x%lx\n", (long)clu_lock_test_buff);
	clu_lock_test_buff = (void *)(((u_long)clu_lock_test_buff + TEST_BLOCKSIZE) & ~(TEST_BLOCKSIZE-1));
	printf("clu_lock_test_buff = 0x%lx\n", (long)clu_lock_test_buff);
	memset(clu_lock_test_buff, 0, TEST_BLOCKSIZE);


}

void test_trash_loop(void)
{
	init_lock_test();
	while(1) {
		trash_disk(0, OFFSET_FIRST_LOCK_BLOCK, 1);
		trash_disk(0, OFFSET_FIRST_LOCK_BLOCK + SPACE_PER_LOCK_BLOCK, 1);	
		usleep(1000000);
	}
}

void test_trash(void)
{
	init_lock_test();

	trash_disk(0, OFFSET_FIRST_LOCK_BLOCK, 1);
	trash_disk(0, OFFSET_FIRST_LOCK_BLOCK + SPACE_PER_LOCK_BLOCK, 1);
	trash_disk(0, OFFSET_FIRST_STATUS_BLOCK, 2);
	trash_disk(0, OFFSET_FIRST_STATUS_BLOCK + SPACE_PER_STATUS_BLOCK, 2);
}


int trash_disk(int which, off_t writeOffset, int blocks)
{
	int ret;

	printf("trash_disk\n");
	if(!clu_lock_test_buff) {
		clu_lock_test_buff = malloc(2*TEST_BLOCKSIZE);
		clu_lock_test_buff = (void *)(((u_long)clu_lock_test_buff + TEST_BLOCKSIZE) & ~(TEST_BLOCKSIZE-1));		
	}
	memset(clu_lock_test_buff, 0, TEST_BLOCKSIZE);

	if(!sharedPartitionFDinited)
		if(initSharedFD()) {
			printf("trash_disk: initSharedFD failed\n");
			goto fail;
		}

	ret = lseek(sharedPartitionFD[which], writeOffset, SEEK_SET);
	if(ret != writeOffset) {
		printf("trash_disk: lseek failed ret = %d\n", ret);
		goto fail;
	}
	while(blocks--) {
		ret = diskRawWrite(sharedPartitionFD[which], (char *)clu_lock_test_buff, TEST_BLOCKSIZE);
		if(ret != TEST_BLOCKSIZE) {
			printf("trash_disk: diskRawWrite failed ret = %d\n", ret);
			goto fail;
		}
	}
	return 0;
  fail:
	return 1;
}
#define TEST_BLKS 10
int test_write_database(void)
{
	ssize_t ret;
	char *data, *p;
	int i;
	int size = TEST_BLKS*TEST_BLOCKSIZE;

	if(zfd < 0)
		zfd = open("/dev/zero", O_RDWR);
	if (zfd == -1) {
		printf("test_write_database: unable to open /dev/zero.\n");
		return -1;
	}
	data = mmap(0, size, PROT_READ|PROT_WRITE, MAP_PRIVATE, zfd, 0);
	if(data == MAP_FAILED) {
		printf("test_write_database: mmap failure\n");
		return -1;
	}
	clu_lock();
	ret = writeDatabase(data, 0);
	clu_un_lock();
	if(ret) {
		printf("expected 0 got %Zd from writeDatabase\n", ret);
		return -1;
	}
	clu_lock();
	ret = readDatabase(data, size);
	clu_un_lock();
	if(ret) {
		printf("expected 0 got %Zd from readDatabase\n", ret);
		return -1;
	}
	p = data;
	for(i = 0; i < TEST_BLKS; i++) {
		*(int *)p = i+1;
		p += TEST_BLOCKSIZE;
	}
	clu_lock();
	ret = writeDatabase(data, size);
	clu_un_lock();
	if(ret != size) {
		printf("expected %d got %Zd from writeDatabase\n", size, ret);
		return -1;
	}
	clu_lock();
	ret = readDatabase(data, size);
	clu_un_lock();
	if(ret != size) {
		printf("expected %d got %Zd from readDatabase\n", size, ret);
		return -1;
	}
	p = data;
	for(i = 0; i < TEST_BLKS; i++) {
		if(*(int *)p != i+1) {
			printf("expected data %d got %d from readDatabase\n",
			       i+1, *(int *)p);
			return -1;
		}
		p += TEST_BLOCKSIZE;
	}
	printf("test_write_database: passed\n");
	return 0;
}
int test_write_database_corrupt_sync(void)
{
	ssize_t ret;
	char *data, *p;
	int i;
	int size = TEST_BLKS*TEST_BLOCKSIZE;

	if(zfd < 0)
		zfd = open("/dev/zero", O_RDWR);
	if (zfd == -1) {
		printf("test_write_database: unable to open /dev/zero.\n");
		return -1;
	}
	data = mmap(0, size, PROT_READ|PROT_WRITE, MAP_PRIVATE, zfd, 0);
	if(data == MAP_FAILED) {
		printf("test_write_database: mmap failure\n");
		return -1;
	}
	clu_lock();
	ret = writeDatabase(data, 0);
	clu_un_lock();
	if(ret) {
		printf("expected 0 got %Zd from writeDatabase\n", ret);
		return -1;
	}
	clu_lock();
	ret = readDatabase(data, size);
	clu_un_lock();
	if(ret) {
		printf("expected 0 got %Zd from readDatabase\n", ret);
		return -1;
	}
	p = data;
	for(i = 0; i < TEST_BLKS; i++) {
		*(int *)p = i+1;
		p += TEST_BLOCKSIZE;
	}
	clu_lock();
	ret = writeDatabase(data, size);
	clu_un_lock();
	if(ret != size) {
		printf("expected %d got %Zd from writeDatabase\n", size, ret);
		return -1;
	}
	printf("part1\n");
	trash_disk(0, OFFSET_CONFIG_DB_HEADER, 1);
	if(test_db_1(data, size))
		return -1;
	
	printf("part2\n");
	trash_disk(0, OFFSET_CONFIG_DB_DATA, 10);
	if(test_db_1(data, size))
		return -1;
	printf("part3\n");
	trash_disk(1, OFFSET_CONFIG_DB_HEADER, 1);
	if(test_db_1(data, size))
		return -1;
	printf("part4\n");
	trash_disk(1, OFFSET_CONFIG_DB_DATA, 10);
	if(test_db_1(data, size))
		return -1;
	return 0;

}
int test_db_1(char *data, ssize_t size)
{
	int i;
	char *p;
	ssize_t ret;

	clu_lock();
	ret = readDatabase(data, size);
	clu_un_lock();
	if(ret != size) {
		printf("expected %Zd got %Zd from readDatabase\n", size, ret);
		return -1;
	}
	p = data;
	for(i = 0; i < TEST_BLKS; i++) {
		if(*(int *)p != i+1) {
			printf("expected data %d got %d from readDatabase\n",
			       i+1, *(int *)p);
			return -1;
		}
		p += TEST_BLOCKSIZE;
	}
	printf("test_write_database: passed\n");
	return 0;
}

	


