/***************************************************************************
 *   Copyright (C) 2005 by KesieV   *
 *   kesiev@hotmail.com   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef KITTEN_H
#define KITTEN_H

#include <kitty_globals.h>
#include <qobject.h>
#include <kio/job.h>
#include <kprocess.h>
#include <kurl.h>
/**
@author KesieV
*/

class Kitten : public QObject
{
Q_OBJECT

public slots:
	void slotpercent (KIO::Job *, unsigned long );
	void slotresult (KIO::Job *job);
	void downloaded(KProcess *);
	void stdout (KProcess *, char *, int );
	void cancel();

public:
    Kitten(KURL source,KURL destination,bool recover=false);
    ~Kitten();
    


private:
	KIO::FileCopyJob *copyJob;
	int percent;
	int done;
	KProcess *proc;
	int proc_is_running;
	QString state;
	QString mode;
	int downloadfinished;
        QString inputcache;

public:
    QString getState();
    int getPercent();
    int getDone();

};


#endif
