/***************************************************************************
                          webapplicationp2p.h -  description
                             -------------------
    begin                : Sun Aug 7 2005
    copyright            : (C) 2005 by Diederik van der Boor
    email                : vdboor --at-- codingdomain.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef WEBAPPLICATIONP2P_H
#define WEBAPPLICATIONP2P_H

#include "p2papplication.h"


/**
 * This class handles the invitations for msn games and online activities.
 * Those invitations are found in the "Games" and "Activities" buttons of the official client.
 *
 * All activities are standard web pages
 * with Flash, ActiveX or DHTML objects.
 *
 * The application parameters are be queried
 * at appdirectory.messenger.msn.com using SOAP.
 * SOAP is a RPC technolog whose messages are
 * formatted as XML and sent over HTTP.
 *
 * @author Diederik van der Boor
 */
class WebApplicationP2P : public P2PApplication
{
  public:
    // The constructor without application parameters (sufficient for incoming sessions)
                           WebApplicationP2P(const QString &localIP, const QString &contactHandle);
    // The constructor with application parameters to start a session
//                           WebApplicationP2P(const QString &localIP, const QString &contactHandle,
//                                             int applicationId);

    // The destructor
    virtual               ~WebApplicationP2P();

    // Return the application's GUID
    static QString         getAppId();


  private:

    // Step one of a contact-started chat: the contact invites the user
    void                   contactStarted1_ContactInvitesUser(const MimeMessage& message);
};

#endif
