/***************************************************************************
                          CurvedWidget.cpp  -  description
                             -------------------
    begin                : Mon May 12 2003
    copyright            : (C) 2003 by Michael Curtis
    email                : michael@kmess.org
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "curvedwidget.h"

#include <qcolor.h>
#include <qlayout.h>
#include <qpointarray.h>
#include <qregion.h>
#include <qwidget.h>

#include <kdebug.h>

// the constructor
CurvedWidget::CurvedWidget( QWidget *parent, const char *name, WFlags f )
  : QWidget( parent, name, f ),
  ourMask_( 0 ),
  filletRadius_(40)
{
  layout_ = new QGridLayout( this, 0, 0, 0, 0 );

  setIndent( 10 );

  setAutoMask( true );

  updateMask();
}



// the destructor
CurvedWidget::~CurvedWidget()
{
}



// get how big our arcs are going to be
int CurvedWidget::getFilletRadius()
{
  return filletRadius_;
}



// get how much the mask is indented from the edge of the widget
int CurvedWidget::getIndent()
{
  return maskIndent_;
}



// get the "root layout", which is just a grid layout for whatever you might need it for
QGridLayout *CurvedWidget::getRootLayout()
{
  return layout_;
}


// set how big our arcs are going to be
void CurvedWidget::setFilletRadius( int filletRadius )
{
  filletRadius_ = filletRadius;

  updateMask();
}



// set how much the mask is indented from the edge of the widget
//  this is primarily useful if you want to add, say, a callout to one corner
void CurvedWidget::setIndent( int maskIndent )
{
  maskIndent_ = maskIndent;

  layout_->setMargin( maskIndent_ + filletRadius_ / 4 );

  updateMask();
}



// draws arcs (fillets) for each corner, and makes them transparent
void CurvedWidget::updateMask()
{
  if ( ourMask_ )
  {
    delete ourMask_;
  }

  ourMask_ = new QRegion( maskIndent_, maskIndent_,
                  width() - maskIndent_ * 2, height() - maskIndent_ * 2 );

  for (int corner = 0; corner < 4; corner++)
  {
    QPointArray arc;
    QPoint filletCorner, arcCorner;

    if ( corner <= 1 )
    {
      filletCorner.setY( maskIndent_ );
      arcCorner.setY( filletCorner.y() );
    }
    else
    {
      filletCorner.setY( height() - maskIndent_ );
      arcCorner.setY( filletCorner.y() - filletRadius_ );
    }

    if ( corner == 1 || corner == 2 )
    {
      filletCorner.setX( maskIndent_ );
      arcCorner.setX( filletCorner.x() );
    }
    else
    {
      filletCorner.setX( width() - maskIndent_ );
      arcCorner.setX( filletCorner.x() - filletRadius_ );
    }

    arc.makeArc( arcCorner.x(), arcCorner.y(),
      filletRadius_, filletRadius_, corner * 16 * 90, 16 * 90 );

    arc.resize( arc.size() + 1 );
    arc.setPoint( arc.size() - 1, filletCorner );

    *ourMask_ -= arc;
  }

  setMask( *ourMask_ );
}


#include "curvedwidget.moc"
