/***************************************************************************
                          popupnotification.h  -  description
                             -------------------
    begin                : Thu Jan 30 2003
    copyright            : (C) 2003 by Mike K. Bennett
    email                : mkb137b@hotmail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef POPUPNOTIFICATION_H
#define POPUPNOTIFICATION_H

#include <qpixmap.h>
#include <qpoint.h>
#include <qtimer.h>
#include <qwidget.h>

// Forward declarations
class CurrentAccount;
class KMessTest;
class Balloon;
class SystemTrayWidget;

/**The ancestor of popup notification classes.
  *@author Mike K. Bennett
  */

class PopupNotification : public QWidget
{
  Q_OBJECT

  friend class KMessTest;

  public: // Public methods
    // The destructor
  	                      ~PopupNotification();

  protected: // Protected methods
    // The constructor
  	                       PopupNotification(SystemTrayWidget *systemTrayWidget, QWidget *parent=0, const char *name=0);
    // Show the popup balloon with the given text, picture, and color
    void                   showBalloon(QString& text, const QPixmap& pixmap, const QString& colorName);

  protected slots: // Protected slots
    // The balloon was clicked
    virtual void           balloonClicked() = 0;


  protected: // Protected attributes
    // A pointer to the current account
    const CurrentAccount  *currentAccount_;

  private: // Private methods
    // Get an "anchor" point from the system tray widget
    QPoint                 anchor();

  private slots: // Private slots
    // Close and delete the balloon
    void                   closeBalloon();
    // Hide the balloon
    void                   hideBalloon();

  private: // Private attributes
    // The popup balloon
    Balloon               *balloon_;
    // The balloon timer
    QTimer                 balloonTimer_;
    // A pointer to the system tray widget, used to find where the balloon should pop up
    SystemTrayWidget      *systemTrayWidget_;

};

#endif
