/***************************************************************************
                          console.cpp  -  description
                             -------------------
    begin                : Sun May 27 2001
    copyright            : (C) 2003 by Troy Corbin Jr.
    email                : tcorbin@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "console.moc"
#include "knightstextview.h"
#include "accel.h"
#include "tabmanager.h"

/* KDE */
#include <klineedit.h>
#include <kiconloader.h>
#include <qregexp.h>
#include <qstyle.h>

Console::Console(QWidget *parent,
                 const char *name,
                 resource *Rsrc ) : QVBox(parent,name)
{
  myResource = Rsrc;
  SelfMoving = FALSE;
  QStyle& Style = QApplication::style();

  margin = Style.defaultFrameWidth();
  myTextView = new KnightsTextView( this, myResource );
  myLineEdit = new KLineEdit( this, "console_edit" );
	/* Configure misc */
	setBG();
	myTextView->setStaticBackground( FALSE );

	connect( myLineEdit, SIGNAL( returnPressed( const QString& ) ), this, SLOT( getText( const QString& ) ) );
	connect( myResource->myAccel, SIGNAL( history_prev() ), this, SLOT( historyBackward() ) );
	connect( myResource->myAccel, SIGNAL( history_next() ), this, SLOT( historyForward() ) );
	connect( myResource->myAccel, SIGNAL( page_up() ), this, SLOT( pageUp() ) );
	connect( myResource->myAccel, SIGNAL( page_down() ), this, SLOT( pageDown() ) );
	connect( myResource->myAccel, SIGNAL( kibitz() ), this, SLOT( kibitz() ) );
	connect( myResource->myAccel, SIGNAL( whisper() ), this, SLOT( whisper() ) );
	connect( myResource->myAccel, SIGNAL( reply_tell() ), this, SLOT( replyPrivate() ) );
	connect( myResource->myAccel, SIGNAL( reply_channel() ), this, SLOT( replyChannel() ) );
	connect( myResource->myAccel, SIGNAL( focus() ), this, SLOT( getFocus() ) );
	connect( myResource->myAccel, SIGNAL( focus( const QChar& ) ), this, SLOT( getFocus( const QChar& ) ) );

	myTextView->show();
	myLineEdit->show();
	show();
}
Console::~Console()
{
	delete myLineEdit;
	delete myTextView;
}
///////////////////////////////////////
//
//	Console::pageDown
//
///////////////////////////////////////
void Console::pageDown( void )
{
	myTextView->pageMove( Qt::Key_PageDown );
}
///////////////////////////////////////
//
//	Console::pageUp
//
///////////////////////////////////////
void Console::pageUp( void )
{
	myTextView->pageMove();
}
///////////////////////////////////////
//
//	Console::recvCMD
//
///////////////////////////////////////
void Console::recvCMD( const Command& command )
{
	QString modText; /* this will hold the text to append after it has been modified with anchors */

	switch(((Command)command).getCommand())
	{
		case CMD_Append_To_Console:
			if( myTextView->contentsY() >= ( myTextView->contentsHeight() - myTextView->visibleHeight() - 12 ) )
			{
				modText = insertTags(((Command)command).getData());
				myTextView->append(modText);
				myTextView->scrollToBottom();
			}
			else
			{
				modText = insertTags(((Command)command).getData());
				myTextView->append(modText);
			}
			break;
		case CMD_Set_Input:
			myLineEdit->setText( ((Command)command).getData() );
			if( !myLineEdit->hasFocus() )
				getFocus();
			break;
		case CMD_Set_Src_Tell:
			lastPrivateSource = ((Command)command).getData();
			break;
		case CMD_Set_Src_Channel:
			lastChannelSource = ((Command)command).getData();
			break;
		default:
			break;
	}
}
///////////////////////////////////////
//
//	Console::getText
//
///////////////////////////////////////
void Console::getText( const QString &text )
{
	/* Append this text into our history */
	history.append( text );
	if( history.count() > 100 )
		history.remove( history.begin() );
	historyIT = history.end();
	emit sendCMD( Command( 0, CMD_Send_To_ICS, text ) );
	myLineEdit->clear();
}
///////////////////////////////////////
//
//	Console::historyBack
//
///////////////////////////////////////
void Console::historyBackward( void )
{
	if( history.count() && ( historyIT != history.begin() ) )
	{
		historyIT--;
		myLineEdit->setText( (*historyIT) );
	}
	if( !myLineEdit->hasFocus() )
		getFocus();
}
///////////////////////////////////////
//
//	Console::historyForward
//
///////////////////////////////////////
void Console::historyForward( void )
{
	if( history.count() && ( historyIT != history.end() ) )
	{
		historyIT++;
		myLineEdit->setText( (*historyIT) );
	}
	if( !myLineEdit->hasFocus() )
		getFocus();
}
///////////////////////////////////////
//
//	Console::replyPrivate
//
///////////////////////////////////////
void Console::replyPrivate( void )
{
	myLineEdit->setText( QString( "tell %1 " ).arg( lastPrivateSource ) );
	if( !myLineEdit->hasFocus() )
		getFocus();
}
///////////////////////////////////////
//
//	Console::replyChannel
//
///////////////////////////////////////
void Console::replyChannel( void )
{
	myLineEdit->setText( QString( "tell %1 " ).arg( lastChannelSource ) );
	if( !myLineEdit->hasFocus() )
		getFocus();
}
///////////////////////////////////////
//
//	Console::kibitz
//
///////////////////////////////////////
void Console::kibitz( void )
{
	myLineEdit->setText( QString( "kibitz " ) );
	if( !myLineEdit->hasFocus() )
		getFocus();
}
///////////////////////////////////////
//
//	Console::whisper
//
///////////////////////////////////////
void Console::whisper( void )
{
	myLineEdit->setText( QString( "whisper " ) );
	if( !myLineEdit->hasFocus() )
		getFocus();
}
///////////////////////////////////////
//
//	Console::getFocus
//
///////////////////////////////////////
void Console::getFocus( void )
{
	if( myLineEdit->hasFocus() )
	{
		getText( myLineEdit->text() );
	}
	setActiveWindow();
	myResource->tabManager->showTab( this );
	myLineEdit->setFocus();
}
void Console::getFocus( const QChar &c )
{
	myLineEdit->setText( myLineEdit->text() + QString( c ) );
	if( !myLineEdit->hasFocus() )
		getFocus();
}
///////////////////////////////////////
//
//	Console::setBG
//
///////////////////////////////////////
void Console::setBG( void )
{
	myTextView->setPaper( QBrush( myResource->COLOR_Background ) );
}

///////////////////////////////////////
//
//	Console::insertTags(QString data)
//
///////////////////////////////////////
QString Console::insertTags(QString data)
{
	QRegExp hyperLinks("(http://(?:.)+(?:\\.(?:[^\\s\\r\\t<])+)+)");
	QRegExp mailLinks("\\b((?:\\w|\\d)+\\@(?:\\w|\\d)+(?:\\.(?:\\d|\\w)+)+)\\b");
	int pos = 0;

	pos = hyperLinks.search(data, 0);
	if(pos >= 0)
	{
		data.replace(hyperLinks, "<A HREF=\"" + hyperLinks.cap(0) + "\">" + hyperLinks.cap(0) + "</A>");
	}
	pos = mailLinks.search(data, 0);
	if(pos >= 0)
	{
		data.replace(mailLinks, "<A HREF=\"mailto:" + mailLinks.cap(0) + "\">" + mailLinks.cap(0) + "</A>");
	}
	return data;
}
