/***************************************************************************
                          dlg_engine.h  -  description
                             -------------------
    begin                : Wed Jul 18 2001
    copyright            : (C) 2003 by Troy Corbin Jr.
    email                : tcorbin@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef DLG_ENGINE_H
#define DLG_ENGINE_H

#include <kdialogbase.h>
#include <klineedit.h>
#include <kcombobox.h>
#include <qgroupbox.h>
#include <qpushbutton.h>
#include <qvbox.h>
#include <qhbox.h>
#include <qstring.h>
#include "definitions.h"
#include "resource.h"

/**
  *@author Troy Corbin Jr.
  */

class dlg_engine : public KDialogBase
{
   Q_OBJECT
	public:
									dlg_engine(QWidget *parent=0, const char *name=0, resource *Rsrc=0, QString ItemName="" );
									~dlg_engine();

	public slots:
		void					slotOk( void );
		void					slotApply( void );
		void					slotCancel( void );
		void					slotFilenameDialog( void );
		void					slotLogFileDialog( void );
		void					slotProtocol( int Index );

	private:
		engineList::Iterator	enginesIT;
		resource							*Resource;
		QString								Name;

		QVBox									*BOX_Parent;
		QHBox									*BOX_NameProto;

		QGroupBox							*BOX_Name;
		KLineEdit							*EDIT_Name;

		QGroupBox							*BOX_Protocol;
		KComboBox							*EDIT_Protocol;

		QGroupBox							*BOX_Filename;
		KLineEdit							*EDIT_Filename;
		QPushButton						*BUTTON_Filename;

		QGroupBox							*BOX_LogFile;
		KLineEdit							*EDIT_LogFile;
		QPushButton						*BUTTON_LogFile;

		QGroupBox							*BOX_Arguments;
		KLineEdit							*EDIT_Arguments;
};

#endif
