/***************************************************************************
                          proto_uci.h  -  description
                             -------------------
    begin                : Sat Oct 26 2002
    copyright            : (C) 2003 by Troy Corbin Jr.
    email                : tcorbin@users.sf.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef PROTO_UCI_H
#define PROTO_UCI_H

#include <qvaluelist.h>
#include "proto_base.h"

/**
  *@author Troy Corbin Jr.
  */

class proto_uci : public proto_base
{
	Q_OBJECT
	public:
											proto_uci( const int ID );
											~proto_uci();

		virtual void			parse( const Command& );
		virtual void			parse( const QString& );

	protected slots:
		void							releaseBuffer( void );

	private:
		QString						engineName;
		QString						engineAuthor;
		QString						difficulty;
		QString						FEN;

		CommandList				*CMDList;
		bool							hintMode;
		bool							initMode;
		bool							JustMoved;
		bool							myArmy;
		bool							Turn;
};

#endif
