/***************************************************************************
                          setpagegeneral.h  -  description
                             -------------------
    begin                : Fri Nov 23 2001
    copyright            : (C) 2003 by Troy Corbin Jr.
    email                : tcorbin@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef SETPAGEGENERAL_H
#define SETPAGEGENERAL_H

#include <klineedit.h>
#include <qwidget.h>
#include <qhbox.h>
#include <qlabel.h>
#include <qlayout.h>
#include <qgroupbox.h>
#include <qbuttongroup.h>
#include <qpushbutton.h>
#include <qradiobutton.h>
#include <qcheckbox.h>
#include "resource.h"

/**
  *@author Troy Corbin Jr.
  */

class setPageGeneral : public QVBoxLayout
{
		Q_OBJECT
	public:
										setPageGeneral(QWidget *parent=0, resource *Rsrc=0);
										~setPageGeneral();
	signals:
		void						enableApply( void );
	public slots:
		void						slot_AutoSave( int state );
		void						slot_Init( int state );
		void						slot_UserName( const QString& );
		void						slot_Pause_On_Minimize( bool state );
		void						slot_Auto_Queen( bool state );
		void						slot_Auto_Flag( bool state );
		void						slot_Reuse_PGN( bool );
		void						slot_PGN_Filename( const QString& );
		void						slot_PGN_Filename_Button( void );
	private:
		QWidget 				*Parent;
		resource				*Resource;

		QGroupBox							*GROUP_UserName;
			KLineEdit							*EDIT_UserName;
		QHBox									*BOX_SaveInit;
			QButtonGroup					*GROUP_AutoSave;
				QRadioButton					*BUTTON_AutoSave_Yes;
				QRadioButton					*BUTTON_AutoSave_No;
				QRadioButton					*BUTTON_AutoSave_Ask;
			QButtonGroup					*GROUP_OnInit;
				QRadioButton					*BUTTON_Init_Nothing;
				QRadioButton					*BUTTON_Init_VsPC;
				QRadioButton					*BUTTON_Init_Connect;
		QGroupBox							*GROUP_Reuse_PGN;
			QCheckBox							*BUTTON_Reuse_PGN;
			QHBox									*BOX_Reuse_PGN;
				KLineEdit							*EDIT_PGN_Filename;
				QPushButton					*BUTTON_PGN_Filename;
		QCheckBox							*BUTTON_Pause_On_Minimize;
		QCheckBox							*BUTTON_Auto_Queen;
		QCheckBox							*BUTTON_Auto_Flag;
};

#endif
