/* @(#) .del-daemon.c 1.13 @(#) */
/***************************************************************\
*	Copyright (c) 1999 First Step Internet Services, Inc.
*		All Rights Reserved
*	Distributed under the BSD Licenese
*
*	Module: CORE
\***************************************************************/

#define _KOALAMUD_DAEMON_C "@(#) nitehawk@winghove.1ststep.net|BitKeeper/deleted/.del-daemon.c|20000307194802|33571 @(#)"

#include "autoconf.h"

#include "version.h"
#include "koalatypes.h"
#include "daemon.h"
#include "network.h"
#include "log.h"

#include "zone.h"
#include "hub.h"
#include "client.h"

koalaerror rundaemon(void)
{
	/* Initialize network code */
	if (netstartup() != KESUCCESS)
	{
		logerr("Error starting network, shutting down");
		return KENONETWORK;
	}

	switch(koptions.daemontype)
	{
	case DAEMON_CLIENT:
		return clientdaemon();
	case DAEMON_ZONE:
		return zonedaemon();
	case DAEMON_HUB:
		return hubdaemon();
	case DAEMON_UNKNOWN:
		logerr("Daemon type unspecified");
		return KEMISSINGARG;
	}
	return KESUCCESS;
}
