h12311
s 00000/00000/00092
d D 1.5 00/03/07 18:09:02 nitehawk 6 5
c Delete: include/lib/fs.h
cC
cK19410
cPBitKeeper/deleted/.del-fs.h
e
s 00000/00000/00092
d D 1.4 00/03/07 11:48:09 nitehawk 5 4
c Turn on SCCS flag
cC
cK35811
cX0xa1
e
s 00005/00001/00087
d D 1.3 00/02/20 10:07:28 nitehawk 4 3
c Added 'first dnode' and 'first block' to superblock
cC
cK05013
e
s 00000/00000/00088
d D 1.2 00/02/19 17:47:24 nitehawk 3 2
c Rename: lib/include/fs.h -> include/lib/fs.h
cK14319
cPinclude/lib/fs.h
e
s 00088/00000/00000
d D 1.1 00/02/17 00:12:44 nitehawk 2 1
cC
cF1
cK51315
cO-rw-r--r--
e
s 00000/00000/00000
d D 1.0 00/02/17 00:12:44 nitehawk 1 0
c BitKeeper file /usr/home/nitehawk/koalamud/lib/include/fs.h
cBnitehawk@paranor.1ststep.net|ChangeSet|19991214032450|08172|1f723a0b4571218e
cHwinghove.1ststep.net
cK45853
cPlib/include/fs.h
cR9f42b2b6130c872d
cV2
cZ-08:00
c______________________________________________________________________
e
u
U
f e 0
f x 0xa1
t
T
I 2
/* %Z% %M% %I% %Z% */
/***************************************************************\
*	Copyright (c) 1999 First Step Internet Services, Inc.
*		All Rights Reserved
*
*	Module: db
\***************************************************************/

#ifndef _KOALAMUD_LIB_FS_H
#define _KOALAMUD_LIB_FS_H "%Z% %K% %Z%"

/* We need fstypes.h for generic file system types */
#include "fstypes.h"

/* This file details the superblock structures that track database state. */

/* The first superblock will always live in block 0.  Other superblock
 * locations are stored in the superblock.  
 */

/* This define is the maximum length of of the mount point string
 * 	For now this is 256 so that everything will fit into a single block */
#define MAXKMNTLEN	256

/* TAG_SUPERBLOCK
 *		This superblock should always be able to fit in a single block.  The
 *		first 256 bytes of the block are used for various attributes of the
 *		superblock.  The last 256 bytes contains the last mount path string.
 *
 * 		Dnodes should be allocated to a superblock in multiples of 4.  This
 * 		ensures that the dnode table will stay on full blocks boundries.
 */
typedef struct TAG_SUPERBLOCK
{
	/* Address pointers */
	kdbfs_blockid_t	fs_sbno;	/* Block number of this superblock */
	kdbfs_blockid_t	fs_dbno;	/* Block number where dnode table starts */
	kdbfs_blockid_t	fs_btno;	/* Block number where block bitmap starts */
	kdbfs_blockid_t fs_nxtsb;	/* Block number of the next superblock */

	/* Counters */
	kdbfs_dnode_t	fs_dsize;	/* Total number of dnodes in database */
	kdbfs_dnode_t	fs_sbdsize;	/* Number of dnodes in superblock */
	kdbfs_blockid_t	fs_size;	/* Total number of blocks in the database */
	kdbfs_blockid_t	fs_sbsize;	/* Number of blocks in this superblock */
	
	/* Table sizes */
	kdbfs_blockid_t fs_dtsize;	/* Number of blocks in dnode table */
	kdbfs_blockid_t fs_btsize;	/* Number of blocks in block table */
	
	/* Usage levels */
	kdbfs_dnode_t	fs_dfree;	/* number of free dnodes in this superblock */
	kdbfs_dnode_t	fs_bfree;	/* number of free blocks in this superblock */

	/* Time information */
	int32_t		fs_ctime;		/* Superblock creation time */
	int32_t		fs_ctimesec;	/* Superblock creation time */
	int32_t		fs_ltime;		/* Last Superblock change time */
	int32_t		fs_ltimesec;	/* Last Superblock change time */

	/* File system flags */
	int8_t		fs_clean;	/* File system is clean flag */

	/* First free locations */
	kdbfs_dnode_t	fs_ffdnode;	/* First Free dnode */
	kdbfs_blockid_t	fs_ffblock;	/* First Free block */

I 4
	/* First dnode and block number tracked by this superblock */
	kdbfs_dnode_t	fs_firstdnode;	/* First dnode tracked by this superblock */
	kdbfs_blockid_t	fs_firstblock;	/* First block tracked by this superblock */

E 4
	/* Reserved for future usage */
D 4
	u_int8_t	fs_reserved[183];
E 4
I 4
	u_int8_t	fs_reserved[175];
E 4

	/* Last mount path is at the end of the superblock */
	u_char	fs_lastmnt[MAXKMNTLEN];		/* Path of last mount */

} superblock;

/* Clean flags */
#define FS_CLEAN	0x0
#define FS_DIRTY	0x1

/* Base allocation levels */
#define FS_BLOCKSBASE		4096
#define FS_BLOCKBITMAPSIZE	(512 * 8)  // 4096
#define FS_BITMAPBLOCKS		(FS_BLOCKSBASE / FS_BLOCKBITMAPSIZE)
#define FS_DNODESBASE		256
#define FS_DNODESPERBLOCK	4
#define FS_DNODEBLOCKS		(FS_DNODESBASE / FS_DNODESPERBLOCK)

#endif
E 2
I 1
E 1
