/***************************************************************************
                          FILENAME  -  description
                             -------------------
    begin                : 10/24/2000
    copyright            : (C) 2000 by Seth Hartbecke
    email                : gandalf@netins.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "agent.h"

#include <jabbercore.h>

Agent::Agent(XMLNode *n)
{
	_jid = n->getAttribute( "jid" );
        _name = n->getChildNode("name")->getValue();
        _description = n->getChildNode("description")->getValue();
        _service = n->getChildNode("service")->getValue();
        _transport = n->getChildNode("transport")->getValue();
        _url = n->getChildNode("url")->getValue();

        _groupChat = true;
        if ( n->getChildNode("groupchat", false) == 0 )
		_groupChat = false;

  	_register = true;
  	if ( n->getChildNode("register", false) == 0 )
        	_register = false;

        _searchable = true;
        if ( n->getChildNode("search", false) == 0 )
                _searchable = false;
}


/*****************************************************************************
				DlgAgents
*****************************************************************************/

DlgAgents *DlgAgents::currentDlg = 0;

void DlgAgents::showDlgAgents()
{
	if (currentDlg != 0)
        	currentDlg->show();
 	else
        	currentDlg = new DlgAgents();
}

DlgAgents::DlgAgents()
	: QWidget( 0, "DlgAgents")
{
	setCaption("Other IM Systems - Konverse");
        setIcon( KGlobal::iconLoader()->loadIcon("agents_dlg", KIcon::User) );

	layout = new QGridLayout( this, 3, 3, 5, 5 );

 	agents = new QListView( this );
        agents->addColumn("Name");
        agents->addColumn("Description");
        layout->addMultiCellWidget( agents, 0, 1, 0, 2 );
        layout->setRowStretch( 1, 3 );
        connect( agents, SIGNAL(clicked(QListViewItem *)), this, SLOT(clickedAgent(QListViewItem *)) );
        connect( agents, SIGNAL(doubleClicked(QListViewItem *)), this, SLOT(dblClickedAgent(QListViewItem *)) );

        btnRegister = new QPushButton("Register", this, "register");
        btnRegister->setMaximumHeight( btnRegister->sizeHint().height() + 10 );
        layout->addWidget( btnRegister, 2, 0 );
        btnRegister->setEnabled( false );
        connect( btnRegister, SIGNAL(clicked()), this, SLOT(registerClicked()) );

        btnClose = new QPushButton("Close", this, "close");
        layout->addWidget( btnClose, 2, 2, Qt::AlignRight );
        connect( btnClose, SIGNAL(clicked()), this, SLOT(closeClicked()) );

        layout->setColStretch( 1, 3 );

        int i;
        for( i=0; i<jabber->numberAgents(); i++ )
        {
                QListViewItem *item = new QListViewItem( agents, jabber->getAgent(i)->name(), jabber->getAgent(i)->description() );
                itemAgentXref.insert( item, jabber->getAgent(i) );
        }

        connect( jabber, SIGNAL( disconnected() ), this, SLOT( systemOffline() ) );

        show();
}

DlgAgents::~DlgAgents()
{
        delete layout;
        delete agents;
        delete btnRegister;
        delete btnClose;
	currentDlg = 0;
}

void DlgAgents::closeEvent(QCloseEvent *)
{
	delete this;
}

void DlgAgents::clickedAgent(QListViewItem *item)
{
        if (item != 0)
        {
                if (itemAgentXref[ item ]->requiresRegistration() )
                        btnRegister->setEnabled( true );
                else
                        btnRegister->setEnabled( false );
        }

        currentItem = item;
}

void DlgAgents::startRegister()
{
        if ( currentItem != 0 )
        {
                if ( itemAgentXref[ currentItem ]->requiresRegistration() )
                {
                        DlgAgentRegister dlg( this, itemAgentXref[ currentItem ] );
                        dlg.exec();
                        //delete dlg;
                }
        }
}


/*****************************************************************************
				DlgAgents
*****************************************************************************/
DlgAgentRegister::DlgAgentRegister( QWidget *parent, Agent *agent )
        : QDialog( parent, "Agent registration", true )
{
        _agent = agent;
        setCaption( "Agent Registration - Konverse" );
        setIcon( KGlobal::iconLoader()->loadIcon("agents_dlg", KIcon::User) );

        QString labelText;
        labelText = "Fetching registration form for " + agent->name() + ".";
        fetchingForm = new QLabel( labelText, this, "txtExplain" );
        fetchingForm->resize( 300, 200 );
        fetchingForm->setAlignment( AlignCenter );

        InfoQuery *request = jabber->queryManager()->createQuery();
        request->setTo( agent->jid() );
        request->setType("get");
        request->setNameSpace("jabber:iq:register");
        connect( request, SIGNAL(responceRecieved(InfoQuery *, InfoQuery *)), this, SLOT(formRecieved(InfoQuery *, InfoQuery *)) );
        request->send();

        resize( 300, 200 );
}

void DlgAgentRegister::formRecieved(InfoQuery *, InfoQuery *responce)
{
        delete fetchingForm;

        if ( responce->getChildNode("error", false) != 0 )
        {
                /* Humm...something went wrong getting the form from the transport */
                KMessageBox::error( this, "There was an error attempting to register this agent:\n\n" + responce->getChildNode("error")->getValue(), "Agent Registration Error - Konverse" );

                reject();

                return;
        }

        _instructions = new QLabel( "<p>" + responce->getChildNode( "query" )->getChildNode("instructions")->getValue() + "</p>", this, "instructions" );
        //_instructions->setText( );
        _key = responce->getChildNode( "query" )->getChildNode("key")->getValue();
        _btnCancel = new QPushButton("&Cancel", this, "cancel");
        connect( _btnCancel, SIGNAL(clicked()), this, SLOT(pushedCancel()) );
        _btnRegister = new QPushButton("&Register", this, "register");
        _btnRegister->setDefault( true );
        connect( _btnRegister, SIGNAL(clicked()), this, SLOT(pushedRegister()) );

        /* First, create all the TextEdit boxes and lables */
        int i;
        for ( i=0; i<responce->getChildNode( "query" )->numberChildNodes(); i++ )
        {
                XMLNode *node = responce->getChildNode( "query" )->getChildNode(i);

                if ( node->getName() != "key" && node->getName() != "instructions" &&  node->getName() != "registered" )
                {
                        QLabel *tmpLabel = new QLabel( node->getName(), this, "inputfiledlabel" );
                        QLineEdit *tmpEdit;
                        if (node->getName() != "password")
                                tmpEdit= new QLineEdit( node->getValue(), this, "inputfiled" );
                        else
                                tmpEdit = (QLineEdit *)new KPasswordEdit( this, "passwordInputField" );

                        _labels.append( tmpLabel );
                        _inputBoxes.append( tmpEdit );
                }
        }

        /* Now put them in a grid layout */
        layout = new QGridLayout( this, 2 + _labels.count(), 3, 5, 5 );

        layout->addMultiCellWidget( _instructions, 0, 0, 0, 2 ); _instructions->show();
        layout->addWidget( _btnCancel, _labels.count() + 1, 2 ); _btnCancel->show();
        layout->addWidget( _btnRegister, _labels.count() + 1, 0 ); _btnRegister->show();

        for ( i=0; i<(int)_labels.count(); i++ )
        {
                layout->addWidget( _labels.at(i), i+1, 0 ); _labels.at(i)->show();
                layout->addMultiCellWidget( _inputBoxes.at(i), i+1, i+1, 1, 2 ); _inputBoxes.at(i)->show();
        }

        layout->activate();

}

void DlgAgentRegister::pushedRegister()
{
        /* Hide the form */
        layout->setEnabled( false );
        _instructions->hide();
        _btnCancel->hide();
        _btnRegister->hide();
        int i;
        for ( i=0; i<(int)_labels.count(); i++ )
        {
                _labels.at(i)->hide();
                _inputBoxes.at(i)->hide();
        }

        fetchingForm = new QLabel( "Submitting registration information", this, "txtExplain" );
        fetchingForm->resize( size().width(), size().height() );
        fetchingForm->setAlignment( AlignCenter );
        fetchingForm->show();

        /* send data */
        InfoQuery *request = jabber->queryManager()->createQuery();
        request->setTo( _agent->jid() );
        request->setType("set");
        request->setNameSpace("jabber:iq:register");
        request->getChildNode( "query" )->getChildNode("key")->setValue( _key );

        for ( i=0; i<(int)_labels.count(); i++ )
        {
                if ( _labels.at(i)->text() != "password" )
                        request->getChildNode( "query" )->getChildNode( _labels.at(i)->text() )->setValue( _inputBoxes.at(i)->text() );
                else
                        request->getChildNode( "query" )->getChildNode( _labels.at(i)->text() )->setValue( ((KPasswordEdit *)(_inputBoxes.at(i)))->password() );
        }
        connect( request, SIGNAL(responceRecieved(InfoQuery *, InfoQuery *)), this, SLOT(regReqRecieved(InfoQuery *, InfoQuery *)) );
        request->send();
}

void DlgAgentRegister::closeEvent( QCloseEvent * )
{
        reject();
}

void DlgAgentRegister::regReqRecieved(InfoQuery *, InfoQuery *responce)
{
        if ( responce->getChildNode("error", false) != 0 )
        {
                KMessageBox::error( this, "There was an error attempting to register this agent:\n\n" + responce->getChildNode("error")->getValue(), "Agent Registration Error - Konverse" );

                layout->setEnabled( true );
                _instructions->show();
                _btnCancel->show();
                _btnRegister->show();
                int i;
                for ( i=0; i<(int)_labels.count(); i++ )
                {
                        _labels.at(i)->show();
                        _inputBoxes.at(i)->show();
                }
                delete fetchingForm;
        }
        else
        {
                delete fetchingForm;

                accept();
        }
}
