/***************************************************************************
                          conversationview.h  -  description                              
                             -------------------                                         
    begin                : Sat Oct 2 1999                                           
    copyright            : (C) 1999 by Seth Hartbecke                         
    email                : gandalf@netins.net                                     
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/


#ifndef CONVERSATIONVIEW_H
#define CONVERSATIONVIEW_H

#include <config.h>

#include <qwidget.h>
#include <qtimer.h>
#include <qframe.h>
#include <qtextbrowser.h>
#include <qdatetime.h>

#include <klocale.h>

#include "jabbercore.h"
#include "jabberid.h"

/**
  * This is the top half of any chat dialog.
  *
  * @author Seth Hartbecke
  */


class ConversationView
	: public QTextBrowser
{
   Q_OBJECT
public:
	ConversationView(QWidget *parent=0, const char *name=0);

        /**
         * Adds the chat line to the dialog.  This does all the magic color coding if you send
         * a color = "auto".  It also timestamps it.
         */
	void addLine(QDateTime &when, QString whatDidTheySay, QString saidByWho, QString color);
        /**
         * Adds the *** style lines to the chat dialog.
         */
        void systemAnnouncement(QDateTime &when, QString announcement, QString color );

private:
        QString HTMLize( QString text );
        void addHTML( QString html );

private slots:
        void scroll();
        void settingChanged( const QString &key, const QString &value );

private:
	int _msgCounter;
        QString _body;
        QTimer *_scrollTimer;
        int _currColor;

        QMap<QString, QString> _nameColorXRef;
        static char *colors[];
};

#endif









