/***************************************************************************
                          FILENAME  -  description
                             -------------------
    begin                : DATE
    copyright            : (C) YEAR by AUTHOR
    email                : EMAIL
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/


#include "dlglogin.h"
#include <qvalidator.h>

DlgLogin *DlgLogin::currentWindow;

DlgLogin::DlgLogin(QWidget *parent, const char *name)
	: QDialog(parent,name)
{
	QSize hintedSize;
	int maxHeight;
	topLayout = new QGridLayout(this, 6, 2, 5, -1, "layoutThingy");

	// Create the input boxes
	txtLoginID = new QLineEdit(this, "txtLoginID");
	hintedSize = txtLoginID->sizeHint();
	maxHeight = hintedSize.height();
	txtLoginID->setMaximumHeight(maxHeight);
	txtLoginID->setMinimumSize(hintedSize.width(), hintedSize.height());
	topLayout->addWidget(txtLoginID, 0, 1);
	
	txtPassword = new QLineEdit(this, "txtPassword");
	txtPassword->setMaximumHeight(maxHeight);
	hintedSize = txtPassword->sizeHint();
	txtPassword->setMinimumHeight(hintedSize.height());
	topLayout->addWidget(txtPassword, 1, 1);
	txtPassword->setEchoMode(QLineEdit::Password);
	
	rememberPassword = new QCheckBox("Remember Password", this, "chkPassword");
	hintedSize = rememberPassword->sizeHint();
	rememberPassword->setMinimumSize(hintedSize.width(), hintedSize.height());
	rememberPassword->setMaximumHeight(hintedSize.height());
	topLayout->addWidget(rememberPassword, 2, 1);
	
	txtNick = new QLineEdit(this, "txtNick");
	txtNick->setMaximumHeight(maxHeight);
	hintedSize = txtNick->sizeHint();
	txtNick->setMinimumHeight(hintedSize.height());
	topLayout->addWidget(txtNick, 3, 1);
	
	// Create the lables
	lblLoginID = new QLabel("Login ID:", this, "lblLoginID");
	topLayout->addWidget(lblLoginID, 0, 0);

	lblPassword = new QLabel("Password:", this, "lblPassword");
	topLayout->addWidget(lblPassword, 1, 0);

	lblNick = new QLabel("Nick:", this, "lblNick");
	topLayout->addWidget(lblNick, 3, 0);		
	
	// This is the server info box
	int maxWidth = 35;
	serverGroupBox = new QGroupBox("Server", this, "serverGroupBox");
	serverLayout = new QGridLayout(serverGroupBox, 3, 2, 15, 5, "layoutThingy");
	
	// Create the lables
	lblServer = new QLabel("Name", serverGroupBox, "lblServer");
	hintedSize = lblServer->sizeHint();
	lblServer->setMinimumSize(hintedSize.width(), hintedSize.height());
	lblServer->setMaximumHeight(hintedSize.height());
	serverLayout->addWidget(lblServer, 0, 0);

	lblPort = new QLabel("Port", serverGroupBox, "lblPort");
	hintedSize = lblServer->sizeHint();
	lblPort->setMinimumSize(hintedSize.width(), hintedSize.height());
	lblPort->setMaximumHeight(hintedSize.height());
	serverLayout->addWidget(lblPort, 0, 1);	
		
	// Create the input boxes
	txtServer = new QLineEdit(serverGroupBox, "txtServer");
	hintedSize = txtServer->sizeHint();
	maxHeight = hintedSize.height();
	txtServer->setMaximumHeight(maxHeight);
	txtServer->setMinimumSize(hintedSize.width()+100, hintedSize.height());
	txtServer->setMaximumWidth(450);
	serverLayout->addWidget(txtServer, 1, 0);
	maxWidth += hintedSize.width()+100;
	
	txtPort = new QLineEdit(serverGroupBox, "txtPort");
	txtPort->setValidator( new QIntValidator( txtPort, "makeSurePortNumber" ) );
	txtPort->setText("5222");
	//tPort = new KIntNumInput(5222, serverGroupBox, 10, "txtPort");
	//ntedSize = txtPort->sizeHint();
	txtPort->setMaximumHeight(hintedSize.height());
	txtPort->setMaximumWidth(50);
	txtPort->setMinimumWidth(50);
	serverLayout->addWidget(txtPort, 1, 1);
	maxWidth += 50;
	
	autoLogin = new QCheckBox("Auto Connect on Startup", serverGroupBox, "chkAutoLogin");
	hintedSize = autoLogin->sizeHint();
	autoLogin->setMinimumSize(hintedSize);
	autoLogin->setMaximumHeight(hintedSize.height());
	serverLayout->addWidget(autoLogin, 2, 0);
	
	serverLayout->activate();
	
	topLayout->addMultiCellWidget(serverGroupBox, 4, 4, 0, 1);
	serverGroupBox->setMinimumWidth(maxWidth);
	
	// Now for the connect button
	btnConnect = new QPushButton("&Connect", this);
	hintedSize = btnConnect->sizeHint();
	btnConnect->setMinimumSize(hintedSize);
	btnConnect->setMaximumSize(hintedSize);
        btnConnect->setDefault( true );
	topLayout->addMultiCellWidget(btnConnect, 5, 5, 0, 0, AlignHCenter);
	
	// The "create new account" button
 	btnNewAccount = new QPushButton("Create &New Account", this);
	hintedSize = btnNewAccount->sizeHint();
	btnNewAccount->setMinimumSize(hintedSize);
	btnNewAccount->setMaximumSize(hintedSize);
	topLayout->addMultiCellWidget(btnNewAccount, 5, 5, 1, 1, AlignHCenter);	


	topLayout->activate();		
		
	// Some other things
	setCaption("Connect to Jabber");
 	resize(350, 200);
 	
 	// Load the present config
	KSimpleConfig *myConfig = new KSimpleConfig( "konverserc" );
	myConfig->setGroup("connection");
	txtLoginID->setText(myConfig->readEntry("login_id"));
	txtNick->setText(myConfig->readEntry("nick"));
	txtPassword->setText(myConfig->readEntry("password"));
	txtServer->setText(myConfig->readEntry("server"));
	txtPort->setText(myConfig->readEntry("port", "5222"));
	rememberPassword->setChecked(myConfig->readBoolEntry("remember_password", true));
	autoLogin->setChecked(myConfig->readBoolEntry("auto_login", true));

  connect( rememberPassword, SIGNAL(clicked()), this, SLOT(savePasswordClicked()) );
  connect( autoLogin, SIGNAL(clicked()), this, SLOT(autoConnectClicked()) );
  connect( btnConnect, SIGNAL(clicked()), this, SLOT(connectPressed()) );
  connect( btnNewAccount, SIGNAL(clicked()), this, SLOT(createAccountClicked()) );

}

DlgLogin::~DlgLogin()
{
	delete topLayout;
	delete serverLayout;
	
	delete lblLoginID;
	delete lblPassword;
	delete lblNick;
	delete lblServer;
	delete lblPort;
		
	delete txtLoginID;
	delete txtPassword;
	delete txtNick;	
	delete txtServer;
	delete txtPort;
	
	delete rememberPassword;
	delete autoLogin;
	
	delete btnConnect;

        currentWindow = 0;	
}

void DlgLogin::showLogin()
{
        if (currentWindow == 0)
                currentWindow = new DlgLogin( 0 );

        currentWindow->show();
}

bool DlgLogin::validateForm()
{
	QString strRetVal;

   strRetVal = txtLoginID->text();
   if (strRetVal.length() == 0)
   {
   	KMessageBox *errorBox = new KMessageBox();
   	errorBox->sorry(this, "Kabber Error", "Login ID is required");
   	return false;
   }

   strRetVal = txtNick->text();
   if (strRetVal.length() == 0)
   {
   	KMessageBox *errorBox = new KMessageBox();
   	errorBox->sorry(this, "Kabber Error", "Nick is required");
   	return false;
   }

   strRetVal = txtServer->text();
   if (strRetVal.length() == 0)
   {
   	KMessageBox *errorBox = new KMessageBox();
   	errorBox->sorry(this, "Kabber Error", "Server name is required.\nThis would be something like jabber.org.");
   	return false;
   }


   strRetVal = txtPort->text();
   if (strRetVal.length() == 0)
   {
   	KMessageBox *errorBox = new KMessageBox();
   	errorBox->sorry(this, "errorMessage", "Port is required.\nThe default port is 5222");
   	return false;
   }



   return true;
}

void DlgLogin::connectPressed()
{
	if (validateForm() == true)
	{
		saveDialogSettings();
		hide();
		jabber->connectToServer( txtServer->text(), txtPort->text().toInt(), txtLoginID->text(), txtPassword->text(), txtNick->text() );	
		close();
	}
}

void DlgLogin::createAccountClicked()
{
	if (validateForm() == true)
	{
		saveDialogSettings();
		hide();
		jabber->connectToServer( txtServer->text(), txtPort->text().toInt(), txtLoginID->text(), txtPassword->text(), txtNick->text(), true );	
		close();
	}
}

void DlgLogin::autoConnectClicked()
{
	if (autoLogin->isChecked())
	{
		rememberPassword->setChecked(true);
	}
}

void DlgLogin::savePasswordClicked()
{
 	if (!rememberPassword->isChecked())
 	{
 		autoLogin->setChecked(false);
 	}
}

void DlgLogin::closeEvent(QCloseEvent *)
{
	emit( dlgClosed() );
	
 	delete this;
}

void DlgLogin::saveDialogSettings()
{
 	KSimpleConfig *myConfig = new KSimpleConfig( "konverserc" );
	myConfig->setGroup("connection");
	myConfig->writeEntry("login_id", txtLoginID->text());
	myConfig->writeEntry("nick", txtNick->text());
	myConfig->writeEntry("remember_password", rememberPassword->isChecked());
	if (rememberPassword->isChecked())
		myConfig->writeEntry("password", txtPassword->text());
	else
		myConfig->writeEntry("password", "");
	myConfig->writeEntry("server", txtServer->text());
	myConfig->writeEntry("port", txtPort->text());
	myConfig->writeEntry("auto_login", autoLogin->isChecked());
	myConfig->sync();
}







