/***************************************************************************
                          expat.h  -  description                              
                             -------------------                                         
    begin                : Thu Jun 8 2000                                           
    copyright            : (C) 2000 by Seth Hartbecke                         
    email                : gandalf@netins.net                                     
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/


#ifndef EXPAT_H
#define EXPAT_H

#include <unistd.h>
#include <stdio.h>

#include <qobject.h>
#include <qstring.h>
#include <qstack.h>
#include <qlist.h>

#include <xmlnode.h>
#include <xmlparse.h>


/*
	This class helps us interface with expat
*/

/**
  * This is the collest class in the whole project.  This class creates a nice clean interface
  * between expat (which is C) and C++.
  *
  * @author Seth Hartbecke (gandalf@netins.net)
  * @short Expat interface
  */

class Expat
	: public QObject
{
	Q_OBJECT
public:
	Expat( QObject *parent, const char *name );
	~Expat();

        /**
         * This feeds more data into the parser.
         */
	void parse(QString data);

        /**
         * Deletes the expat datastructures and prepares a new one.  Nice for soft
         * resets.  Used by XMLStream
         */
	void reset();

protected:
        /**
         * This method is called whenever a new tag is recieved.  You should ovveride this.
         */
	virtual void recievedTag( XMLNode *n);
        /**
         * This method is called when the first complete tag is recieved.
         */
	virtual void rootTagRecieved(XMLNode *n);
        /**
         * This method is called when first tag recieved is ended.  This usually means
         * that the document is EOF.
         */
	virtual void rootTagEnded();
        /**
         * This is any errors that expat produces.  The class will not work anymore after an
         * error has been encountered unless you call reset.
         */
	virtual void parserError( QString errorMsg, int line );

private:
	static void startElement(void *userData, const XML_Char *name, const XML_Char **atts);
	static void endElement(void *userData, const XML_Char *name);
	static void charData(void *userData, const char *data, int len);

	bool rootRecieved;

	void init();
	void cleanup();

	QList<XMLNode> newNodes;		// Nodes that need to be sent out
						// via recievedTag
	QStack<XMLNode> fillingNodes;		//Nodes that are currently being filled

	XML_Parser parser;
};

#endif
