/***************************************************************************
                          group.h  -  description
                             -------------------
    begin                : Sun Oct 22 2000
    copyright            : (C) 2000 by Seth Hartbecke
    email                : gandalf@netins.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef _GROUP_H_
#define _GROUP_H_

#include <qobject.h>
#include <qmap.h>
#include <qlist.h>
#include <qvector.h>

class User;

/**
 * This is NOT the centeral repository for group information.
 * Any changes you want to make to groups MUST be done via
 * the user's object.
 *
 * This is just so various parts of the application have one place
 * to go for a list of group names.
 *
 * @author Seth Hartbecke
 * @short Groups database
*/

class Group
	: public QObject
{
	Q_OBJECT
public:
 	Group( QString name );

        /**
         * Get the name of the group this object represents.
         */
        QString getName() { return _name; };


        /**
         * Returns the number of users in this group.
         */
        int numberUsers() { return _users.count(); };
        /**
         * Gets the nth user in the group.
         */
        User *getUser( int n ) { return _users.at(n)->u; };

	/**
         * called by the user class, all group modifications should be
         * done via the methos on the user class
         */
	void addUser( User * );
        /**
         * Don't call this.  I need to setup the friend stuff.
         */
        void removeUser( User * );

signals:
        /**
         * This signal is emitted whenever a user is added to the group.
         */
	void newUser( Group *, User * );
        /**
         * This signal is emitted whenever a user is removed from the group.
         */
        void deleteUser( Group *, User *u );
        /**
         * This signal is emitted whenever a group is deleted.
         */
        void deletedGroup( Group * );
        /**
         * I forget why I created this signal.......
         */
        void newGroup( Group * );

private:
	struct UserPtr
        {
        	User *u;
        };

        QList<UserPtr> _users;
	QString _name;
};

#endif


