/***************************************************************************
                          konverse.h  -  description
                             -------------------
    begin                : Fri Oct  1 22:39:20 CDT 1999

    copyright            : (C) 1999 by Seth Hartbecke
    email                : gandalf@netins.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef _KONVERSE_H_
#define _KONVERSE_H_

#include <kapp.h>
#include <kpopupmenu.h>
#include <kdockwindow.h>

#include <qwidget.h>
#include <qtimer.h>
#include <qlabel.h>

#include <jabbercore.h>
#include <dlgchat.h>
#include <dlglogin.h>
#include <qmessagebox.h>
#include <dlgconnectinprogress.h>
#include <userlistmenu.h>
#include <rostertree.h>
#include <agent.h>


/**
 * This is the widget that docks into the tool tray.
 *
 * @author Seth Hartbecke (gandalf@netins.net)
 * @short Icon in the tool tray
 */
class Konverse : public KDockWindow {
  Q_OBJECT
public:
  /** construtor */
  Konverse(QWidget*parent=0,const char* name=0);
  /** destructor */
  ~Konverse();

public slots:
	/**
	 * Blinks the icon :)
	 */
	void blinkIcon();

	/**
	 * This is the message bin telling us how many unread messages there are
	 */
	void updateNumberUnread(int numberUnRead);

	/**
	 * This will kill the client
	 */
	void shutdown();

	/**
	 * this catches whenever we go online/offline
	 */
	void onlineStatusChanged();

	/**
	 * This catches whenever our status changes whilst online
	 */
	void connectionStatusChanged();

	/**
	 * Just tells the roster to show
	 */
	void showRosterList();

	/**
	 * Shows the roster if it's hidden and hides it if it's showing
	 */
	void toggleRosterList();

	/**
	 * A stupid about dialog
	 */
	void showAbout();

	/**
	 * Not much better
	 */
	void showHelp();

	/**
	 * Show the connect dialog...unless it is already showing
	 */
	void showConnectDialog();

private slots:
	/* The connect dialog closed */
	void connectDialogCosed();

        void showAgentsDialog() { DlgAgents::showDlgAgents(); };

protected:
	/* Redraws the icon in the tool tray */
	void displayPixmap();

	/* Popup menu, or read oldest message*/
	void mousePressEvent(QMouseEvent *event);
private:
	/* Show the popup menu */
	void popupMenu();

	/* Read the oldest message...unless there are no messages then we
	   show the roster */
	void mouseDoubleClickEvent(QMouseEvent *event);

	/**
	 * Set the normal (non-flashing) tool tray icon according to
	 * current status.
	 */
	void setNormalIcon();

	QPixmap currentIcon;
	QPixmap normalIcon;
	int currentIconShown;
	QTimer *blinkTimer;
	
	/* Many images used in the program */
	QPixmap onlineIcon;
	QPixmap offLineIcon;
	QPixmap awayIcon;
	QPixmap xawayIcon;
	QPixmap dndIcon;
	QPixmap chatIcon;
	QPixmap messageIcon;
	QPixmap PixHelp, PixQuit, PixAbout, PixConnect, PixDisconnect, PixShowRoster;

	RosterTree *rosterList;
	
	DlgLogin *loginDialog;

	KPopupMenu *popup;
	int connectID, disconnectID, userMenuID, statusMenuID, otherIMSystemsID;
  	UserListMenu *userListMenu;	

};
#endif


















