/***************************************************************************
                          rostertree.h  -  description
                             -------------------
    begin                : Tue Jan 11 2000
    copyright            : (C) 2000 by Seth Hartbecke
    email                : gandalf@netins.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/


#ifndef ROSTERTREE_H
#define ROSTERTREE_H

#include <qwidget.h>
#include <qlistview.h>
#include <qpopupmenu.h>
#include <qmap.h>

#include <ktmainwindow.h>
#include <kmenubar.h>
#include <kapp.h>
#include <ksimpleconfig.h>
#include <ktoolbar.h>

#include <jabbercore.h>
#include <user.h>
#include <useradd.h>
#include <group.h>
#include <setstatus.h>
#include <useradd.h>
#include <agent.h>
#include <dlglogin.h>
#include <dlggrpchat.h>


/**
  *@author Seth Hartbecke

  This is the roster....
  */


class RosterMenuItem;
class UserItem;
class GroupItem;
class ResourceItem;

/**
 * This is the roster tree window.  This positions the toolbar, iconbar, and initializes the tree in the middle
 *
 * @short Roster window
 * @author Seth Hartbecke (gandalf@netins.net)
 * @see RosterMenuItem
 * @see GroupItem
 * @see UserItem
 * @see ResourceItem
*/
class RosterTree
	: public KMainWindow
{
   Q_OBJECT
private:

public:
	RosterTree(QWidget *parent=0, const char *name=0);
	~RosterTree();

protected:
	bool queryClose();
private:
        enum BarPosition{ Unmanaged, Floating, Top, Bottom, Right, Left, Flat};

private slots:

	void newGroup( Group *g);

        void rightButtonClicked(QListViewItem *, const QPoint &);

	// This slots are called when an option from the popup menu
	// is chosen
	void dblClick(QListViewItem *);

        void addUser() { UserAdd::showUserAdd(); };
        void setupTransports() { DlgAgents::showDlgAgents(); };
        void connectToJabber() { DlgLogin::showLogin(); };
        void disconnect() { jabber->disconnect();  };
        void changeConnection();
        void exit() { jabber->disconnect(); kapp->quit(); };
	void newMessage();
        void groupChat() { DlgJoinGrpChat::showDialog(); };
        void showPrefs() { jabber->prefs()->showPrefsDialog( "roster" ); };

        void connectionChanged();

private:

        QListViewItem *getGroup(QString group);
	QListViewItem *createGroup(QString group);
        //QWidget *container;
        //QGridLayout *topLayout;
        SetStatusCbo *currStatus;
	QListView *roster;
        KToolBar *_statusToolbar;
        KToolBar *_mainToolbar;

        QPopupMenu *rosterMnu;
        QPopupMenu *helpMnu;
        int connectID, disconnectID, setStatusID, otherIMSystemsID, addUserID;

	QPopupMenu *popup;
	QListViewItem *chosenItem;	// The item under the cursor
					// when it was right clicked on


};

/**
 * All the components of the roster are really "intelegent" components.  Each watches it's own piece of
 * data and updates itself to react accordingly.  They are all bulit from this class so that the roster
 * can handle them all the same way (event though some may be groups, users, or presence info
 *
 * @short Roster tree piece
 * @author Seth Hartbecke (gandalf@netins.net)
 * @see GroupItem
 * @see UserItem
 * @see ResourceItem
 */
class RosterMenuItem
	: public QObject, public QListViewItem
{
public:
	RosterMenuItem( QListViewItem *parent, const char *name=0);
        RosterMenuItem( QListView *parent, const char *name=0);

	/**
	 * This is called when this item is dbl-clicked
	 */
	virtual void dblClick();

	/**
	 * This is called when this item is right-clicked on.
	 */
        virtual void rightClick( const QPoint & );
protected:
        void show();
        void hide();

private:
        QListViewItem *_parentItem;
        QListView *_parentView;
        int parentType;

};

/**
 * The intellegent group item, it watches for new user's in it's group and creates the necessary
 * itmes when a new user shows up.  It also watches for deletetions (of users or even this group)
 *
 * @short Roster tree piece that is a group
 * @author Seth Hartbecke (gandalf@netins.net)
 * @see RosterMenuItem
 * @see UserItem
 */
class GroupItem
	: public RosterMenuItem
{
	Q_OBJECT
public:
 	GroupItem( Group *g, QListView *parent, const char *name = 0);

private slots:
        /**
	 * Called when this group has been deleted.  This is the signal to this item
	 * that it should remove itself from the roster
	 */
	void deleteGroup( Group * );

	/**
	 * A user has been "deleted" or really just removed from this group.
	 */
        void deleteUser( Group *, User * );

	/**
	 * A user has been added to this group
	 */
        void addUser( Group *, User * );
private:

        QMap<User *, UserItem *> userItems;
        QListView *_parent;

};

/**
 * The intellegent item that is a user.
 *
 * @see RosterMenuItem
 * @see ResourceItem
 */
class UserItem
	: public RosterMenuItem
{
	Q_OBJECT
public:
	UserItem( QListViewItem *group, User *u, QString g );
        UserItem( QListView *parent, User *u, QString g );
	QString getJID();


        void dblClick();
        void rightClick( const QPoint & );

public slots:
	void informationChanged(User *u);
	void presenceChanged( User *u, UserPresence *p );
        void presenceDeleted( User *, UserPresence * );

 	void startChat();
        void showUserInfo();
        void removeFromGroup();
        void removeFromRoster();


private:
        void construct( User *u, QString g );

	User *whoAmI;
        QPopupMenu *_popup;
        QMap<QString, ResourceItem *> presenceMap;
        QString _group;

};

/**
 * The intelegent component to a roster that is a resource.
 *
 * @see RosterMenuItem
 */
class ResourceItem
	: public RosterMenuItem
{
	Q_OBJECT
public:
	ResourceItem( UserItem *parent, UserPresence *presence );
        ~ResourceItem();

        void dblClick();
        void rightClick( const QPoint & );
public slots:
 	void startChat();
        void showUserInfo();

private:
        UserPresence *_presence;
        QPopupMenu *_popup;
};

#endif
