/***************************************************************************
                          userpresence.cpp  -  description
                             -------------------
    begin                : Fri Jan 7 2000
    copyright            : (C) 2000 by Seth Hartbecke
    email                : gandalf@netins.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/


#include "userpresence.h"

UserPresence::UserPresence(User *u, QString resource )
	: QObject(u, resource)
{
	user = u;
	txtResource = resource;

	/* These are the defaults */
	intPriority = 0;
	isAvailable = false;
	txtStatus = "Unknown";
        _show = JabberCore::Unknown;
        deleteTimer = 0;
}

UserPresence::~UserPresence()
{
	if( !deleteTimer )
        	delete deleteTimer;

	emit( presenceDeleted( getUser(), this ) );
}

void UserPresence::processPresence(XMLNode *t)
{
	bool changed = false;

//	if (t->numberChildNodes() != 0)
//	{
		QString newPriority;
		newPriority = t->getChildNode("priority")->getValue();
		if (!newPriority.isEmpty())
		{
               if (newPriority.toInt() != intPriority)
               {
                  intPriority = newPriority.toInt();
                  changed = true;
               }
		}
         else
            intPriority = 1;

                QString newShow = t->getChildNode("show")->getValue();

                if ( newShow == "chat" && _show != JabberCore::Chat )
                {
                        _show = JabberCore::Chat;
                        changed = true;
                }
                else if ( newShow.isEmpty() && _show != JabberCore::Normal )
                {
                	      _show = JabberCore::Normal;
                        changed = true;
                }
                else if ( newShow == "away" && _show != JabberCore::Away )
                {
                        _show = JabberCore::Away;
                        changed = true;
                 }
                 else if ( newShow == "xa" && _show != JabberCore::ExtendedAway )
                {
                	_show = JabberCore::ExtendedAway;
                        changed = true;
                }
                else if ( newShow == "dnd" && _show != JabberCore::DND )
                {
                       	_show = JabberCore::DND;
                        changed = true;
                }

		QString newAvailable;
		newAvailable = t->getAttribute("type");
		if (newAvailable.isEmpty()
		    && isAvailable == false)
		{
			isAvailable = true;
			changed = true;
		}
		if (strcmp(newAvailable, "unavailable") == 0)
		{
			isAvailable = false;
             _show = JabberCore::Offline;
			changed = true;
		}


		QString newStatus;
		newStatus = t->getChildNode("status")->getValue();
		if (strcmp(newStatus, txtStatus) != 0)
		{
			txtStatus = newStatus;
			changed = true;

		}
//	}

        if ( !isAvailable && !deleteTimer )
        {
        	deleteTimer = new QTimer( this, "Time till delete" );
                connect( deleteTimer, SIGNAL(timeout()), this, SLOT( deleteTimeout() ) );
                deleteTimer->start( 300000, TRUE );
        }

        if ( isAvailable && deleteTimer )
        {
               delete deleteTimer;
                deleteTimer = 0;
        }

	if (changed == true)
	{
		emit(presenceChanged(user, this));
	}
}

QPixmap UserPresence::getIcon()
{
	switch ( _show )
        {
         	case JabberCore::Chat:
                	return KGlobal::iconLoader()->loadIcon("user_chat", KIcon::Small );
         	case JabberCore::Normal:
                	return KGlobal::iconLoader()->loadIcon("user_online", KIcon::Small );
         	case JabberCore::Away:
                	return KGlobal::iconLoader()->loadIcon("user_away", KIcon::Small );
         	case JabberCore::ExtendedAway:
                	return KGlobal::iconLoader()->loadIcon("user_xaway", KIcon::Small );
         	case JabberCore::DND:
                	return KGlobal::iconLoader()->loadIcon("user_dnd", KIcon::Small );
         	case JabberCore::Offline:
                	return KGlobal::iconLoader()->loadIcon("user_offline", KIcon::Small );
         	default:
                	return KGlobal::iconLoader()->loadIcon("user_unknown", KIcon::Small );
        }
}

