#ifndef _WRAPEDIT_H
#define _WRAPEDIT_H

#include <config.h>

#include <qmlined.h>
#include <qwidget.h>
#include <qfontmetrics.h>

/**
 * A simple wrap edit widget (QTextArea with wrap turned on)
 *
 * Ok, so maby this is not a big deal anymore.  But with QT 1.x the QTextArea did not
 * have wrap built into it.   Now this is just here because if the user presses ctlEnter()
 * it will emit a special signal that the chat dialog can catch and use to send the message.
 */
class WrapEdit
	 : public QMultiLineEdit
{
Q_OBJECT
public:
	WrapEdit(QWidget *p = 0, const char *n = 0);

signals:
        /**
	 * If the user presses enter this signal is emitted.  The whole reason for having
	 * this class is to have this signal....
	 */
	void ctlEnter();
protected:
	void keyPressEvent(QKeyEvent *) ;
};

#endif /* _WRAPEDIT_H */
