/***************************************************************************
                          xmlfile.cpp  -  description                              
                             -------------------                                         
    begin                : Fri Jun 9 2000                                           
    copyright            : (C) 2000 by Seth Hartbecke                         
    email                : gandalf@netins.net                                     
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/


#include "xmlfile.h"
#include <unistd.h>
#include <stdlib.h>

XMLFile::XMLFile(QString filePath, QString filename, QObject *parent, const char *name )
	: Expat(parent, name), XMLNode()
{
	if (filePath.isNull())
	{
		filePath = getenv("HOME");
		filePath+= "/.kde/share/apps/konverse/";
	}
		
	testDir( filePath );
		
	XMLNode::setName("file");
	
	file.sprintf("%s/%s", (const char *)filePath, (const char *)filename);
	
	read();
}

XMLFile::~XMLFile()
{

}

void XMLFile::testDir(QString name)
{
	DIR *dp;
	dp = opendir(name);
	if(dp == 0L)
		::mkdir (name, ALLPERMS);
	else
		closedir( dp );
}

void XMLFile::read()
{
 	fd = open( (const char *)file, O_CREAT, DEFFILEMODE );
 	
 	if (fd == -1)
 	{
 		printf("XMLFile::read() Unable to open the file %s\n", (const char *)file);
 		return;
 	}
 	
 	char buf[ 16385 ];
 	int retVal;
 	
	do
	{
		retVal = ::read( fd, (void *)&buf, 16385 );
		
		if (retVal != 0 && retVal != -1)
		{
		 	buf[retVal] = '\0';
		 	parse( buf );
		}
		
	} while (retVal != 0 && retVal != -1);
	
	close(fd);
}

void XMLFile::rootTagRecieved(XMLNode *n)
{
 	XMLNode::setName( n->getName() );
 	
 	QString attribute, value;
 	int i;
 	for (i=0; i<n->numberAttributes(); i++)
 	{
 		n->getAttributePair(i, attribute, value);
 		setAttribute( attribute, value );
 	}
}

void XMLFile::recievedTag( XMLNode *n )
{
	addChildNode( n );
}

void XMLFile::clear()
{
    	Expat::reset();
    	
    	int i;
    	for (i=0; i<numberChildNodes(); i++)
    		deleteChildNode( i );
}

bool XMLFile::sync()
{
 	fd = open( (const char *)file, O_CREAT | O_TRUNC | O_RDWR, DEFFILEMODE );
 	
 	if (fd == -1)
 	{
 		printf("XMLFile::sync() Unable to open the file %s\n", (const char *)file);
 		return false;
 	}

 	QString toWrite = XMLNode::getXML();
        QCString utf = toWrite.utf8();
 	int retVal;

 	retVal = write( fd, (const void *)utf, (int)utf.length() );

 	if (retVal != (int)utf.length() )
 	{
 		printf("XMLFile::sync()...write failed! Errorno %d\n", errno);
 		return false;
 	}

 	close( fd );

 	return true;
}
