/***************************************************************************
                          korinoco_kickerapplet.cpp  -  description
                             -------------------
    begin                : Mit Sep 26 14:58:20 CEST 2001
    copyright            : (C) 2001 by Stefan Winter
    email                : mail@stefan-winter.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
#include <kglobal.h>
#include <klocale.h>
#include <kconfig.h>
#include <kapp.h>
#include <kmessagebox.h>
#include <qtimer.h>
#include "korinoco_kickerapplet.h"


extern "C"
{
  KPanelApplet* init( QWidget *parent, const QString configFile)
  {
    KGlobal::locale()->insertCatalogue("korinoco_kickerapplet");
    return new Korinoco_kickerapplet(configFile, KPanelApplet::Normal,
                      KPanelApplet::About | KPanelApplet::Help | KPanelApplet::Preferences,
                      parent, "korinoco_kickerapplet");
  }
}

int
sockets_open(void)
{
        int ipx_sock = -1;              /* IPX socket                   */
        int ax25_sock = -1;             /* AX.25 socket                 */
        int inet_sock = -1;             /* INET socket                  */
        int ddp_sock = -1;              /* Appletalk DDP socket         */
        inet_sock=socket(AF_INET, SOCK_DGRAM, 0);
        if(inet_sock!=-1)
                return inet_sock;
        ipx_sock=socket(AF_IPX, SOCK_DGRAM, 0);
        if(ipx_sock!=-1)
                return ipx_sock;
        ax25_sock=socket(AF_AX25, SOCK_DGRAM, 0);
        if(ax25_sock!=-1)
                return ax25_sock;
        ddp_sock=socket(AF_APPLETALK, SOCK_DGRAM, 0);
        return ddp_sock;
}

Korinoco_kickerapplet::Korinoco_kickerapplet(const QString& configFile, Type type, int actions, QWidget *parent, const char *name)
       : KPanelApplet(configFile, type, 1 , parent, name)
{
   // Get the current application configuration handle
  skfd = -1;		/* generic raw socket desc.	*/

  /* Create a channel to the NET kernel. */
  if((skfd = sockets_open()) < 0)
    {
      perror("Error opening socket!");
      exit(-1);
    };


   ksConfig = config();


   mainView = new myview(skfd, this);
	mainView->setBackgroundMode(QWidget::PaletteBackground);
	mainView->setMinimumSize(QSize(0,0));
  QTimer * counter = new QTimer( this );
  connect( counter, SIGNAL(timeout()), mainView, SLOT(repaint()) );
  counter->start( 250 );
   mainView->show();
}

Korinoco_kickerapplet::~Korinoco_kickerapplet()
{
}

void Korinoco_kickerapplet::about()
{
   KMessageBox::information(0, i18n("The KOrinoco Kicker applet\n\nThis applet ist part of the KOrinoco suite. \nPlease launch KOrinoco itself for more\ninformation."));
}

int Korinoco_kickerapplet::widthForHeight( int height ) const
{
   return 25;
}

int Korinoco_kickerapplet::heightForWidth( int width ) const
{
   return width;
}

