/***************************************************************************
 *   Copyright (C) 2008-2011 by Marcel Hasler                              *
 *   mahasler@gmail.com                                                    *
 *                                                                         *
 *   This file is part of KOSD.                                            *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation, either version 3 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the          *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program. If not, see <http://www.gnu.org/licenses/>.  *
 ***************************************************************************/

#ifndef KOSDKEYSD_H
#define KOSDKEYSD_H

#include <KActionCollection>
#include <KDEDModule>

#include "kosd/kosd.h"

class KOsdKeysD : public KDEDModule
{
    Q_OBJECT

public:
    KOsdKeysD(QObject* parent, const QList<QVariant>&);
    ~KOsdKeysD();

private slots:
    void increaseVolume();
    void decreaseVolume();
    void muteVolume();
    void showVolume();

    void increaseBrightness();
    void decreaseBrightness();
    void showBrightness();

    void showBattery();

    void parseConfiguration();

private:
    void showVolume(unsigned int volume, bool muted);
    void showPixmapVolume(unsigned int volume, bool muted);
    void showSvgVolume(unsigned int volume, bool muted);

    void showPixmapBrightness();
    void showSvgBrightness();

    void showPixmapBattery();
    void showSvgBattery();

    KActionCollection *m_actions;
    bool m_useSvg;
};

#endif // KOSDKEYSD_H
