/*
 *  Copyright (C) 1999 Peter Amstutz
 *
 *  This program is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU General Public License as
 *  published by the Free Software Foundation; either version 2 of *the
 *  License, or (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
 *  02111-1307 USA 
 */

#ifndef _FONT_H_
#define _FONT_H_

#include <ggi/ggi.h>

typedef struct Char_fnt
{
    int x, y, w;
} Char_fnt;

typedef struct ScrollWindow_txt 
{
    int x, y, w, h;
    int rows;
    int currow;
} ScrollWindow_txt;

typedef struct InputBox_txt
{
    int x, y, w, h;
    int curpos;
    char *string;
    int maxlen;
} InputBox_txt;

typedef struct ListBoxElements_txt 
{
	struct ListBoxElements_txt *next;
	struct ListBoxElements_txt *prev;
	void *elem;
} ListBoxElements_txt;

typedef struct ListBox_txt
{
	int x, y, w, h, sy, sh;
	ListBoxElements_txt *top;
	ListBoxElements_txt *current;
	int (*activatefunc)(void *elem);
	int (*deactivatefunc)(void *elem);
	void (*redrawfunc)(int x, int y, int w, int h, void *elem);
} ListBox_txt;

void txtInit();
void txtPuts(int sx, int sy, char* msg);
void txtPrintf(int sx, int sy, char* fmt, ...);
ScrollWindow_txt *txtMakeScrollWindow(int x, int y, int w, int h);
void txtScrollWindowPrintf(ScrollWindow_txt *sw, char *fmt, ...);
void txtClearScrollWindow(ScrollWindow_txt *sw);
InputBox_txt *txtMakeInputBox(int x, int y, int w, int h, int start, char *outstr, int maxlen);
void txtDoInputBox(InputBox_txt *ib, ggi_event *ev);
void txtClearInputBox(InputBox_txt *ib);
ListBox_txt *txtMakeListBox(int x, int y, int w, int h, 
							int (*activatefunc)(void *),
							int (*deactivatefunc)(void *),
							void (*redrawfunc)(int x, int y, int w, int h, void *elem));
void txtAddToListBox(ListBox_txt *lb, void *elem);
void txtDoListBox(ListBox_txt *lb, ggi_event *ev);
void txtDrawListBox(ListBox_txt *lb);

#endif
