/*
 *  Copyright (C) 1999 Peter Amstutz
 *
 *  This program is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU General Public License as
 *  published by the Free Software Foundation; either version 2 of *the
 *  License, or (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
 *  02111-1307 USA 
 */

#include <stdlib.h>
#include "../log.h"
#include "../ballistics.h"
#include "../terrain.h"
#include "../aiexterns.h"
#include "laser.h"

Shellstat_bal wepLaserInit(struct Projectilepos_bal *prjpos, void** guide,
			   Shellstat_bal (*initexplosion)(struct Projectilepos_bal *prjpos, 
							  void** explosioninfo), 
			   void** explosioninfo)
{
    Player_pl *plhit = NULL;
    int ix, iy;
    
    /* Set ox,oy to lazer destination */
    prjpos->ox=prjpos->x;
    prjpos->oy=prjpos->y;

    if(prjpos->vx <= 0 && prjpos->vy <= 0)
	return initexplosion(prjpos, explosioninfo);

    while(1)
    {   
        if(balCheckIntersect(prjpos->ox, prjpos->oy, prjpos->x, prjpos->y, &plhit, &ix, &iy))
        {
            /* we hit ground or tank, that's the end */
            prjpos->ox=ix;
            prjpos->oy=iy;
            break;
        }
        if(prjpos->ox < 0)
        {
            prjpos->ox=0;
            break;
        }
        if(prjpos->ox > ter_sizex)
        {
            prjpos->ox=ter_sizex;
            break;
        }
        if(prjpos->oy < 0)
        {
            prjpos->oy=0;
            break;
        }
        if(prjpos->oy > ter_sizey)
        {
            prjpos->oy=ter_sizey;
            break;
        }

        /* move our ox and oy by the velocities */
        prjpos->ox+=prjpos->vx;
        prjpos->oy+=prjpos->vy;
    }
    
    logPrintf(DEBUG, "Lazer destination: (%06.2f, %06.2f)\n", prjpos->ox, prjpos->oy);

	/* Don't know if we need these???? 
	aihExplosionHook(prjpos);
	aihExplosionHook(prjpos);
    */
    /* Nothing to do here, just explode */
	return initexplosion(prjpos, explosioninfo);
}

Shellstat_bal wepLaserExplosionInit(struct Projectilepos_bal *prjpos, 
									void** explosioninfo)
{
    struct LineExplosion_wep *e = (struct LineExplosion_wep*)malloc(sizeof(struct LineExplosion_wep));

    e->x1=prjpos->x;
    e->y1=prjpos->y;
    e->x2=prjpos->ox;
    e->y2=prjpos->oy;
    e->width=4;
    e->id=prjpos->id;
    e->duration=40;
    e->wid = prjpos->wid;
    
    *((struct LineExplosion_wep**)explosioninfo)=e;
    return EXPLODING;
}

Shellstat_bal wepLaserExplosion(void* info)
{
    struct LineExplosion_wep *prj = (struct LineExplosion_wep *)info;
    Player_pl *pcur;
	
    prj->duration--;
    if(prj->duration < 0)
    {
	return FREEING;
    }
    else 
    {
	/* Velocity is 0 -- suicide*/
	if(prj->x1 == prj->x2 && prj->y1 == prj->y2)
	{
	    pcur = plLookupPlayer(prj->id);
	    if(pcur && pcur->ready == READY )
	    {
		pcur->last_hit = prj->id;
		plDamageTank(pcur, EXPLOSIVE,
			     prj->id, prj->wid, 1);
	    }
	}
	else
	{
	    for(pcur=pl_begin; pcur; pcur=pcur->next) 
	    {
		if(pcur->ready==READY && plPlayerInCircleArea(pcur, prj->x2, prj->y2, prj->width))
		{
		    pcur->last_hit = prj->id;
		    plDamageTank(pcur, EXPLOSIVE,
				 prj->id, prj->wid, 1);
	    }
	    }
	}
	return EXPLODING;
    }    
}

