#ifndef KSIPPREFERENCES_H_INCLUDED
#define KSIPPREFERENCES_H_INCLUDED

#include <qtabdialog.h>

#include "../dissipate2/sipclient.h"
#include "callaudio.h"
#include "../config.h"

class QLineEdit;
class QMultiLineEdit;
class QButtonGroup;
class KSipPreferences : public QTabDialog
{
	Q_OBJECT
public:
	KSipPreferences( SipClient *client, CallAudio *ca, QWidget *parent = 0, const char *name = 0 );
	~KSipPreferences( void );

protected slots:
	void slotOk( void );
	void slotApply( void );
	void slotCancel( void );
	void resetSettings( void );

private:
	enum ExpProxy { DontUseExpProxy, UseExpProxy };
	enum HideVia { NoHide, HideHop, HideRoute };
	enum CallForward { FwActive, FwInactive };
	enum Socket { UDP, TCP };
	enum Stun { stunYes, stunNo };
	enum Symmetric { symmetricYes, symmetricNo };
	enum SymMedia { symMediaYes, symMediaNo };
	#ifdef SRTP
	enum Srtp { enableSRTP, disableSRTP };
	#endif
	
	SipClient *c;
	CallAudio *audio;
	QLineEdit *proxyaddr;
	QLineEdit *forwardaddr;
	QLineEdit *maxforwards;
	QLineEdit *phonebook;
	QLineEdit *expires;
	QLineEdit *subscribeExpires;
	QLineEdit *stunServerAddr;
	QLineEdit *stunRequestPeriod;
	QMultiLineEdit *forwardmsg;
	QMultiLineEdit *busymsg;
	QButtonGroup *expbg;
	QButtonGroup *hidebg;
	QButtonGroup *forbg;
	QButtonGroup *stun;
	QButtonGroup *symmetric;
	QButtonGroup *symMedia;
	QButtonGroup *socket;
	QLineEdit *mediaMinPort;
	QLineEdit *mediaMaxPort;
	#ifdef SRTP
	QButtonGroup* srtp;
	QLineEdit* masterKey;
	#endif
};

#endif // KSIPPREFERENCES_H_INCLUDED
