 /**************************************************************************
 *   Copyright (C) 2004 by  Holger Macht                                   *
 *                            <hmacht@suse.de>                             *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.          *
 ***************************************************************************/

#include "schemes.h"
#include "kpowersave_debug.h"

/*! 
*  \file 	schemes.cpp
*  \brief 	This file contains the code of classe Schemes.
*/

/*!
 * This function counts the numbers of available schemes from powersave
 * \return 	Integer value with the number of schemes
 */
int Schemes::count() {
	return scheme_list.size();
}

/*!
 * This function give the currently available list of available schemes.
 * The name of the schemes are untranslated as recieved from powersave daemon.
 * \return 		QStringList with the available schemes
 */
QStringList Schemes::schemeList() {
	return scheme_list;
}

/*!
 * This function give the name of the current scheme. 
 * The name of the scheme is untranslated as recieved from powersave daemon.
 * \return 		QString with the name of the current scheme
 */
QString Schemes::currentScheme() {
	return current_scheme;
}

/*!
 * This function give the name of the default batttery scheme. 
 * The name of the scheme is untranslated as recieved from powersave daemon.
 * \return 		QString with the name of the battery scheme
 */
QString Schemes::batteryScheme() {
	return battery_scheme;
}

/*!
 * This function give the name of the default scheme if the machine is on AC. 
 * The name of the scheme is untranslated as recieved from powersave daemon.
 * \return 		QString with the name of the AC scheme
 */
QString Schemes::acScheme() {
	return ac_scheme;
}

/*!
 * This function set the default current scheme.
 * \param _current_scheme	Character pointer to the name of the scheme to set
 */
void Schemes::setCurrentScheme( char *_current_scheme ){
	if(scheme_list.contains(_current_scheme))
		current_scheme = _current_scheme;
	else
		myDebug("Scheme: %s not set as current scheme, because it is not listed.", _current_scheme);
}

/*!
 * This function set the default batter scheme.
 * \param _battery_scheme 	Character pointer to the name of the scheme to set
 */
void Schemes::setBatteryScheme( char *_battery_scheme ) {
	if(scheme_list.contains(_battery_scheme))
		battery_scheme = _battery_scheme;
	else
		myDebug("Scheme: %s not set as battery scheme, because it is not listed.", _battery_scheme);
}

/*!
 * This function set the default on AC scheme.
 * \param _ac_scheme	Character pointer to the name of the scheme to set
 */
void Schemes::setAcScheme( char *_ac_scheme ) {
	if(scheme_list.contains(_ac_scheme))
		ac_scheme = _ac_scheme;
	else
		myDebug("Scheme: %s not set as ac scheme, because it is not listed.", _ac_scheme);
}

/*!
 * This function add a scheme to the list of available schemes.
 * \param scheme	Character pointer to the name of the scheme to add.
 */
void Schemes::append( char *scheme ) {
	if(!scheme_list.contains(scheme))
		scheme_list.append( scheme );
	else
		myDebug("Scheme: %s not added to list, because it is already listed.", scheme );
}

/*!
 * This function clear the list of available schemss.
 */
void Schemes::clear() {
	scheme_list.clear();
	current_scheme = "";
	battery_scheme = "";
	ac_scheme = "";
}

/*!
 * This function check if the given list of schemes differ from the current 
 * list of schemes hold by this class.
 * \param other_schemes		QStringList with names of schemes
 * \return boolean value with the result of the compare.
 * \retval true if they are different
 * \retval false if they contains the same names of schemes
 */
bool Schemes::differ( QStringList other_schemes ) {
	QStringList::iterator other_node = other_schemes.begin();
	for ( QStringList::iterator node = scheme_list.begin();
	      node != scheme_list.end();
	      ++node ) {
		if ( (QString)*node != (QString)*other_node ) {
			return true;
		}

		++other_node;
	}

	return false;
}

