/***************************************************************************
 *   Copyright (C) 2005 by Nicolas Ternisien                               *
 *   nicolas.ternisien@gmail.com                                           *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

//Qt includes
#include <qlayout.h>
#include <qvgroupbox.h>
#include <qbuttongroup.h>
#include <qlabel.h>
#include <qpushbutton.h>
#include <qvbox.h>
#include <qhbox.h>

//KDE includes
#include <klocale.h>
#include <kactioncollection.h>
#include <kbuttonbox.h>
#include <klistbox.h>
#include <kfiledialog.h>
#include <kurl.h>
#include <kmessagebox.h>
#include <kiconloader.h>
#include <kdebug.h>

//Project includes
#include "cupsOptions.h"
#include "ksystemlogConfig.h"

CupsOptions::CupsOptions(QWidget *parent) :
	QWidget(parent),
	tabs(this, "tabs"),
	cupsFileList(this, i18n("<qt><p>These files will be analyzed to display <b>Cups log</b>. This list also determines the order in which the files are read.</p></qt>")),
	cupsAccessFileList(this, i18n("<qt><p>These files will be analyzed to display <b>Cups Web Server log</b>. This list also determines the order in which the files are read.</p></qt>"))
	{
	
	QHBoxLayout *layout = new QHBoxLayout(this);
	layout->setAutoAdd(true);

	tabs.addTab(&cupsFileList, Globals::cupsMode->pixmap, Globals::cupsMode->name);
	tabs.addTab(&cupsAccessFileList, Globals::cupsAccessMode->pixmap, Globals::cupsAccessMode->name);
	
	connect(&cupsFileList, SIGNAL(fileListChanged(int)), this, SLOT(slotFileListChanged(int)));
	connect(&cupsAccessFileList, SIGNAL(fileListChanged(int)), this, SLOT(slotFileListChanged(int)));
	
	readConfig();
	

}

CupsOptions::~CupsOptions() {

}

bool CupsOptions::isValid() {
	if (cupsFileList.count()>0 && cupsAccessFileList.count()>0)
		return(true);
	else
		return(false);
}

void CupsOptions::slotFileListChanged(int itemLeft) {
	if (itemLeft==0)
		emit optionsChanged(false);
	else
		emit optionsChanged(true);
}

void CupsOptions::saveConfig() {
	kdDebug() << "Save config from CupsOptions" << endl;
	
	QStringList list;
	
	int count=cupsFileList.count();
	
	for (int i=0; i<count; i++) {
		list.push_back(cupsFileList.getText(i));
	}
	
	KSystemLogConfig::setCupsPaths(list);

	list.clear();
	
	count=cupsAccessFileList.count();
	
	for (int i=0; i<count; i++) {
		list.push_back(cupsAccessFileList.getText(i));
	}
	
	KSystemLogConfig::setCupsAccessPaths(list);

}

void CupsOptions::readConfig() {
	QStringList cupsFiles(KSystemLogConfig::cupsPaths());
		
	QStringList::iterator it;
	for(it=cupsFiles.begin(); it!=cupsFiles.end(); ++it) {
		cupsFileList.insertItem(*it);
	}

	QStringList cupsAccessFiles(KSystemLogConfig::cupsAccessPaths());
		
	for(it=cupsAccessFiles.begin(); it!=cupsAccessFiles.end(); ++it) {
		cupsAccessFileList.insertItem(*it);
	}
}

#include "cupsOptions.moc"
