/***************************************************************************
                          selectfiledialog.cpp  -  description
                             -------------------
    begin                : Mon Jun 4 2001
    copyright            : (C) 2001 by Brachet Pascal
    email                : pascal.brachet@free.fr
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "selectfiledialog.h"
#include <klocale.h>
#include <klineedit.h>
#include <kfiledialog.h>
#include <qfileinfo.h>

selectfiledialog::selectfiledialog(QWidget *parent, const char *name )
:KDialogBase( parent, 0L, true,name, Ok | Cancel, Ok )
{
	setCaption(name);
  QWidget *page = new QWidget(this);
  setMainWidget(page);

  QHBoxLayout *topLayout = new QHBoxLayout( page, 0, spacingHint() );


  QLabel_1= new QLabel(page,"NoName");
  QLabel_1->setText(i18n("File (without extension) :"));

  source_edit = new KURLRequester( page, "source_edit",true );
  source_edit->setFocusPolicy( QWidget::StrongFocus );
  source_edit->lineEdit()->setText( "" );
  source_edit->lineEdit()->setFocus();
  source_edit->fileDialog()->setMode(KFile::File);
  topLayout->addWidget(QLabel_1);
  topLayout->addSpacing(spacingHint());
  topLayout->addWidget(source_edit);
  resize(350,80);

  connect(source_edit,SIGNAL(textChanged(const QString &)),SLOT(sourceTextChanged(const QString &)));
}
selectfiledialog::~selectfiledialog(){
}

void selectfiledialog::sourceTextChanged(const QString &name)
{
   QFileInfo fi(name);
   source_edit->lineEdit()->setText(fi.baseName()) ;
}
