/***************************************************************************
 *   Copyright (C) 2006 by Raul Fernandes                                  *
 *   rgfbr@yahoo.com.br                                                    *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#include "sdictplugin.h"
#include "sdict.h"

#include <kgenericfactory.h>

#include <qregexp.h>
#include <qlabel.h>

#ifndef NDEBUG

#include <kdebug.h>

#endif


K_EXPORT_COMPONENT_FACTORY( ktranslator_sdict,
                            KGenericFactory<SdictPlugin>( "ktranslator_sdict" ) )

SdictPlugin::SdictPlugin( QObject *parent, const char*, const QStringList &args )
            : KTranslator::DictionaryPlugin(parent, "Sdict" )
{
   KLocale::setMainCatalogue("ktranslator");
   dic = new Sdict( args[0] );
   dictName = args[1];
   setOk( dic->isOk() );
   setEnabled( true );
   m_tooltip = i18n( "Sdictionary Dictionary\nTitle: %1\nCopyright: %2\nVersion: %3\nFrom: %4\nTo: %5\nWords: %6" ).arg( dic->title() ).arg( dic->copyright() ).arg( dic->version() ).arg( dic->inlang() ).arg( dic->outlang() ).arg( dic->size() );
}

QString SdictPlugin::search( const QString &word )
{

  #ifndef NDEBUG

  kdDebug() << "Sdict Plugin search()" << endl;

  #endif

  QString result = dic->search( word );

  if( result.isEmpty() ) return QString ( "<dicName>%1</dicName><font color=#000000>%2</font>" ).arg( dictName ).arg( i18n( "Word not found" ) );

  int pos = result.find( '\n' );
  QString headword = result.left( pos );
  result = result.mid( pos ).replace( "\n", "<br>" );
  return QString( "<dicName>%1</dicName><headword>%2</headword><definition>%3</definition>" ).arg( dictName ).arg( headword ).arg( result );
}


QWidget *SdictPlugin::confPage()
{
  return new QLabel( "This plugin has no configurations", 0 );
}


void SdictPlugin::applyConf( QWidget * )
{
  return;
}


int SdictPlugin::size()
{
  return dic->size();
}
