/***************************************************************************
 *   Copyright (C) 2002-2006 by                                            *
 *   Marcel Wiesweg (marcel@wiesweg-online.de)                             *
 *   and Raul Fernandes (rgfbr@yahoo.com.br)                               *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

/***************************************************************************
                          ocrwatchdog.cpp  -  description
                             -------------------
    begin                : Mit Jul 24 2002
    copyright            : (C) 2002 by Marcel Wiesweg
    email                : marcel@wiesweg-online.de
 ***************************************************************************/


#include "ocrwatchdog.h"

#include <qfontmetrics.h>
#include <qvbuttongroup.h>
#include <qlabel.h>
#include <qlayout.h>
#include <qradiobutton.h>

#include <kapplication.h>
#include <kglobalaccel.h>
#include <klocale.h>
#include <kkeydialog.h>
#include <kkeynative.h>
#include <kconfig.h>

#ifndef NDEBUG

  #include <kdebug.h>

#endif

#include <X11/X.h>
#include <X11/Xlib.h>

class MyQPixmap : public QPixmap {  //quick hack
public:
   MyQPixmap(int a,int b) : QPixmap(a,b) {};
   void setUninit(uint uninit) { data->uninit=uninit; }
};

OcrWatchdog::OcrWatchdog(QWidget *parent, const char *name ) :
   QWidget(parent,name)
{
    KConfig *config = kapp->config();
    config->setGroup( "general" );
    QString a = config->readEntry( "ModifierKey", "Control" );
    if( a == "Shift" ) button = 1<<0;
    else if( a == "Control" ) button = 1<<2;
    else if( a == "Alt" ) button = 1<<3;
    else if( a == "Winkey" ) button = 1<<6;
}


OcrWatchdog::~OcrWatchdog(){
   deactivate();
}

/** Performs grabbing */
void OcrWatchdog::clickOccured(){

#ifndef NDEBUG

   kdDebug()<<"OcrWatchdog::clickOccured"<<endl;

#endif

   Window root;
   Window child;
   uint mask;
   int rootX, rootY, winX, winY;
   if (!XQueryPointer( qt_xdisplay(), qt_xrootwin(), &root, &child, &rootX, &rootY, &winX, &winY, &mask))
      return;
   int h=3*fontMetrics().height();       //guessing height
   int w=30*fontMetrics().width('e');    //guessing width

   int x=rootX-(w/2);  //root(X,Y) is the center of rectangle x,y,w,h
   int y=rootY-(h/2);

   //Copied from QPixmap::grabWindow()
    Display *dpy = x11AppDisplay();
    if ( w <= 0 || h <= 0 ) {

     #ifndef NDEBUG

       kdError()<<"QFontMetrics return zero or negative values. Is this possible?"<<endl;

     #endif

       return;
    }
    MyQPixmap pm( w, h );   // create new pixmap
    pm.setUninit( false );//pm.data->uninit = FALSE;
    GC gc = qt_xget_temp_gc( qt_xscreen(), false );
    XSetSubwindowMode( dpy, gc, IncludeInferiors );
    //kdDebug()<<"Grabbing: "<<x<<","<<y<<" "<<w<<","<<h<<" "<<rootX<<","<<rootY<<endl;
    XCopyArea( dpy, qt_xrootwin() /*window*/, pm.handle(), gc, x, y, w, h, 0, 0 );
    XSetSubwindowMode( dpy, gc, ClipByChildren );
    //kdDebug()<<"Emitting gotIt"<<endl;
    //Not quite sure if this is necessary. But the GlobalAccel had a Sync grabbed keyboard.
    XAllowEvents(qt_xdisplay(), SyncKeyboard, CurrentTime);
    emit gotIt(pm,rootX-x,rootY-y);
}


/** No descriptions */
void OcrWatchdog::activate()
{
  kapp->installX11EventFilter( this );
  XGrabButton( qt_xdisplay(), Button3, button, qt_xrootwin(), false, ButtonReleaseMask, GrabModeSync, GrabModeAsync, None, None );
  XGrabButton( qt_xdisplay(), Button3, button | LockMask, qt_xrootwin(), false, ButtonReleaseMask, GrabModeSync, GrabModeAsync, None, None );
  XGrabButton( qt_xdisplay(), Button3, button | Mod2Mask, qt_xrootwin(), false, ButtonReleaseMask, GrabModeSync, GrabModeAsync, None, None );
  XGrabButton( qt_xdisplay(), Button3, button | LockMask | Mod2Mask, qt_xrootwin(), false, ButtonReleaseMask, GrabModeSync, GrabModeAsync, None, None );
  XGrabButton( qt_xdisplay(), Button3, button | Mod5Mask, qt_xrootwin(), false, ButtonReleaseMask, GrabModeSync, GrabModeAsync, None, None );
  XGrabButton( qt_xdisplay(), Button3, button | LockMask | Mod5Mask, qt_xrootwin(), false, ButtonReleaseMask, GrabModeSync, GrabModeAsync, None, None );
  XGrabButton( qt_xdisplay(), Button3, button | Mod2Mask | Mod5Mask, qt_xrootwin(), false, ButtonReleaseMask, GrabModeSync, GrabModeAsync, None, None );
  XGrabButton( qt_xdisplay(), Button3, button | LockMask | Mod2Mask | Mod5Mask, qt_xrootwin(), false, ButtonReleaseMask, GrabModeSync, GrabModeAsync, None, None );
}

/** No descriptions */
void OcrWatchdog::deactivate()
{
  kapp->removeX11EventFilter( this );
  XUngrabButton( qt_xdisplay(), Button3, button, qt_xrootwin() );
  XUngrabButton( qt_xdisplay(), Button3, button | LockMask /*CapsLock*/, qt_xrootwin() );
  XUngrabButton( qt_xdisplay(), Button3, button | Mod2Mask /*NumLock*/, qt_xrootwin() );
  XUngrabButton( qt_xdisplay(), Button3, button | LockMask | Mod2Mask, qt_xrootwin() );
  XUngrabButton( qt_xdisplay(), Button3, button | Mod5Mask /*ScrollLock*/, qt_xrootwin() );
  XUngrabButton( qt_xdisplay(), Button3, button | LockMask | Mod5Mask, qt_xrootwin() );
  XUngrabButton( qt_xdisplay(), Button3, button | Mod2Mask | Mod5Mask, qt_xrootwin() );
  XUngrabButton( qt_xdisplay(), Button3, button | LockMask | Mod2Mask | Mod5Mask, qt_xrootwin() );
}


bool OcrWatchdog::x11Event( XEvent *event )
{
  XAllowEvents( qt_xdisplay(), SyncPointer, CurrentTime );
  if( event->type != ButtonPress || event->xbutton.button != 3 /*is not Button 3*/ || !(event->xbutton.state & button) ) return false;
  clickOccured();
  return true;
}


void OcrWatchdog::loadModifierKey()
{
    KConfig *config = kapp->config();
    config->setGroup( "general" );
    QString a = config->readEntry( "ModifierKey", "Control" );
    if( a == "Shift" ) button = 1<<0;
    else if( a == "Control" ) button = 1<<2;
    else if( a == "Alt" ) button = 1<<3;
    else if( a == "Winkey" ) button = 1<<6;
    deactivate();
    activate();
}

#include "ocrwatchdog.moc"
